/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerClient;
import software.amazon.awssdk.services.computeoptimizer.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetLambdaFunctionRecommendationsResponse;
import software.amazon.awssdk.services.computeoptimizer.model.LambdaFunctionRecommendation;

public class GetLambdaFunctionRecommendationsIterable
implements SdkIterable<GetLambdaFunctionRecommendationsResponse> {
    private final ComputeOptimizerClient client;
    private final GetLambdaFunctionRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetLambdaFunctionRecommendationsIterable(ComputeOptimizerClient client, GetLambdaFunctionRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetLambdaFunctionRecommendationsResponseFetcher();
    }

    public Iterator<GetLambdaFunctionRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LambdaFunctionRecommendation> lambdaFunctionRecommendations() {
        Function<GetLambdaFunctionRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lambdaFunctionRecommendations() != null) {
                return response.lambdaFunctionRecommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetLambdaFunctionRecommendationsResponseFetcher
    implements SyncPageFetcher<GetLambdaFunctionRecommendationsResponse> {
        private GetLambdaFunctionRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(GetLambdaFunctionRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetLambdaFunctionRecommendationsResponse nextPage(GetLambdaFunctionRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return GetLambdaFunctionRecommendationsIterable.this.client.getLambdaFunctionRecommendations(GetLambdaFunctionRecommendationsIterable.this.firstRequest);
            }
            return GetLambdaFunctionRecommendationsIterable.this.client.getLambdaFunctionRecommendations((GetLambdaFunctionRecommendationsRequest)((Object)GetLambdaFunctionRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

