/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizerautomation.model.EstimatedMonthlySavings;
import software.amazon.awssdk.services.computeoptimizerautomation.model.StepStatus;
import software.amazon.awssdk.services.computeoptimizerautomation.model.StepType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationEventStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationEventStep> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(AutomationEventStep.getter(AutomationEventStep::eventId)).setter(AutomationEventStep.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(AutomationEventStep.getter(AutomationEventStep::stepId)).setter(AutomationEventStep.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final SdkField<String> STEP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepType").getter(AutomationEventStep.getter(AutomationEventStep::stepTypeAsString)).setter(AutomationEventStep.setter(Builder::stepType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepType").build()}).build();
    private static final SdkField<String> STEP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepStatus").getter(AutomationEventStep.getter(AutomationEventStep::stepStatusAsString)).setter(AutomationEventStep.setter(Builder::stepStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepStatus").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(AutomationEventStep.getter(AutomationEventStep::resourceId)).setter(AutomationEventStep.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTimestamp").getter(AutomationEventStep.getter(AutomationEventStep::startTimestamp)).setter(AutomationEventStep.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimestamp").build()}).build();
    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedTimestamp").getter(AutomationEventStep.getter(AutomationEventStep::completedTimestamp)).setter(AutomationEventStep.setter(Builder::completedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedTimestamp").build()}).build();
    private static final SdkField<EstimatedMonthlySavings> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("estimatedMonthlySavings").getter(AutomationEventStep.getter(AutomationEventStep::estimatedMonthlySavings)).setter(AutomationEventStep.setter(Builder::estimatedMonthlySavings)).constructor(EstimatedMonthlySavings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, STEP_ID_FIELD, STEP_TYPE_FIELD, STEP_STATUS_FIELD, RESOURCE_ID_FIELD, START_TIMESTAMP_FIELD, COMPLETED_TIMESTAMP_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomationEventStep.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String stepId;
    private final String stepType;
    private final String stepStatus;
    private final String resourceId;
    private final Instant startTimestamp;
    private final Instant completedTimestamp;
    private final EstimatedMonthlySavings estimatedMonthlySavings;

    private AutomationEventStep(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.stepId = builder.stepId;
        this.stepType = builder.stepType;
        this.stepStatus = builder.stepStatus;
        this.resourceId = builder.resourceId;
        this.startTimestamp = builder.startTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final StepType stepType() {
        return StepType.fromValue(this.stepType);
    }

    public final String stepTypeAsString() {
        return this.stepType;
    }

    public final StepStatus stepStatus() {
        return StepStatus.fromValue(this.stepStatus);
    }

    public final String stepStatusAsString() {
        return this.stepStatus;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant completedTimestamp() {
        return this.completedTimestamp;
    }

    public final EstimatedMonthlySavings estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationEventStep)) {
            return false;
        }
        AutomationEventStep other = (AutomationEventStep)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.stepTypeAsString(), other.stepTypeAsString()) && Objects.equals(this.stepStatusAsString(), other.stepStatusAsString()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.completedTimestamp(), other.completedTimestamp()) && Objects.equals(this.estimatedMonthlySavings(), other.estimatedMonthlySavings());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationEventStep").add("EventId", (Object)this.eventId()).add("StepId", (Object)this.stepId()).add("StepType", (Object)this.stepTypeAsString()).add("StepStatus", (Object)this.stepStatusAsString()).add("ResourceId", (Object)this.resourceId()).add("StartTimestamp", (Object)this.startTimestamp()).add("CompletedTimestamp", (Object)this.completedTimestamp()).add("EstimatedMonthlySavings", (Object)this.estimatedMonthlySavings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "stepType": {
                return Optional.ofNullable(clazz.cast(this.stepTypeAsString()));
            }
            case "stepStatus": {
                return Optional.ofNullable(clazz.cast(this.stepStatusAsString()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "startTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "completedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completedTimestamp()));
            }
            case "estimatedMonthlySavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eventId", EVENT_ID_FIELD);
        map.put("stepId", STEP_ID_FIELD);
        map.put("stepType", STEP_TYPE_FIELD);
        map.put("stepStatus", STEP_STATUS_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("startTimestamp", START_TIMESTAMP_FIELD);
        map.put("completedTimestamp", COMPLETED_TIMESTAMP_FIELD);
        map.put("estimatedMonthlySavings", ESTIMATED_MONTHLY_SAVINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationEventStep, T> g) {
        return obj -> g.apply((AutomationEventStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String stepId;
        private String stepType;
        private String stepStatus;
        private String resourceId;
        private Instant startTimestamp;
        private Instant completedTimestamp;
        private EstimatedMonthlySavings estimatedMonthlySavings;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationEventStep model) {
            this.eventId(model.eventId);
            this.stepId(model.stepId);
            this.stepType(model.stepType);
            this.stepStatus(model.stepStatus);
            this.resourceId(model.resourceId);
            this.startTimestamp(model.startTimestamp);
            this.completedTimestamp(model.completedTimestamp);
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getStepType() {
            return this.stepType;
        }

        public final void setStepType(String stepType) {
            this.stepType = stepType;
        }

        @Override
        public final Builder stepType(String stepType) {
            this.stepType = stepType;
            return this;
        }

        @Override
        public final Builder stepType(StepType stepType) {
            this.stepType(stepType == null ? null : stepType.toString());
            return this;
        }

        public final String getStepStatus() {
            return this.stepStatus;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        public final Builder stepStatus(StepStatus stepStatus) {
            this.stepStatus(stepStatus == null ? null : stepStatus.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getCompletedTimestamp() {
            return this.completedTimestamp;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final EstimatedMonthlySavings.Builder getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings != null ? this.estimatedMonthlySavings.toBuilder() : null;
        }

        public final void setEstimatedMonthlySavings(EstimatedMonthlySavings.BuilderImpl estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings != null ? estimatedMonthlySavings.build() : null;
        }

        @Override
        public final Builder estimatedMonthlySavings(EstimatedMonthlySavings estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public AutomationEventStep build() {
            return new AutomationEventStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationEventStep> {
        public Builder eventId(String var1);

        public Builder stepId(String var1);

        public Builder stepType(String var1);

        public Builder stepType(StepType var1);

        public Builder stepStatus(String var1);

        public Builder stepStatus(StepStatus var1);

        public Builder resourceId(String var1);

        public Builder startTimestamp(Instant var1);

        public Builder completedTimestamp(Instant var1);

        public Builder estimatedMonthlySavings(EstimatedMonthlySavings var1);

        default public Builder estimatedMonthlySavings(Consumer<EstimatedMonthlySavings.Builder> estimatedMonthlySavings) {
            return this.estimatedMonthlySavings((EstimatedMonthlySavings)((EstimatedMonthlySavings.Builder)EstimatedMonthlySavings.builder().applyMutation(estimatedMonthlySavings)).build());
        }
    }
}

