/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.EnrollmentStatus;
import software.amazon.awssdk.services.computeoptimizerautomation.model.OrganizationRuleMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnrollmentConfigurationResponse
extends ComputeOptimizerAutomationResponse
implements ToCopyableBuilder<Builder, GetEnrollmentConfigurationResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetEnrollmentConfigurationResponse.getter(GetEnrollmentConfigurationResponse::statusAsString)).setter(GetEnrollmentConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetEnrollmentConfigurationResponse.getter(GetEnrollmentConfigurationResponse::statusReason)).setter(GetEnrollmentConfigurationResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> ORGANIZATION_RULE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationRuleMode").getter(GetEnrollmentConfigurationResponse.getter(GetEnrollmentConfigurationResponse::organizationRuleModeAsString)).setter(GetEnrollmentConfigurationResponse.setter(Builder::organizationRuleMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRuleMode").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTimestamp").getter(GetEnrollmentConfigurationResponse.getter(GetEnrollmentConfigurationResponse::lastUpdatedTimestamp)).setter(GetEnrollmentConfigurationResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_REASON_FIELD, ORGANIZATION_RULE_MODE_FIELD, LAST_UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEnrollmentConfigurationResponse.memberNameToFieldInitializer();
    private final String status;
    private final String statusReason;
    private final String organizationRuleMode;
    private final Instant lastUpdatedTimestamp;

    private GetEnrollmentConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.organizationRuleMode = builder.organizationRuleMode;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
    }

    public final EnrollmentStatus status() {
        return EnrollmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final OrganizationRuleMode organizationRuleMode() {
        return OrganizationRuleMode.fromValue(this.organizationRuleMode);
    }

    public final String organizationRuleModeAsString() {
        return this.organizationRuleMode;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationRuleModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnrollmentConfigurationResponse)) {
            return false;
        }
        GetEnrollmentConfigurationResponse other = (GetEnrollmentConfigurationResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.organizationRuleModeAsString(), other.organizationRuleModeAsString()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetEnrollmentConfigurationResponse").add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("OrganizationRuleMode", (Object)this.organizationRuleModeAsString()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "organizationRuleMode": {
                return Optional.ofNullable(clazz.cast(this.organizationRuleModeAsString()));
            }
            case "lastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("organizationRuleMode", ORGANIZATION_RULE_MODE_FIELD);
        map.put("lastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEnrollmentConfigurationResponse, T> g) {
        return obj -> g.apply((GetEnrollmentConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationResponse.BuilderImpl
    implements Builder {
        private String status;
        private String statusReason;
        private String organizationRuleMode;
        private Instant lastUpdatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnrollmentConfigurationResponse model) {
            super(model);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.organizationRuleMode(model.organizationRuleMode);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnrollmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getOrganizationRuleMode() {
            return this.organizationRuleMode;
        }

        public final void setOrganizationRuleMode(String organizationRuleMode) {
            this.organizationRuleMode = organizationRuleMode;
        }

        @Override
        public final Builder organizationRuleMode(String organizationRuleMode) {
            this.organizationRuleMode = organizationRuleMode;
            return this;
        }

        @Override
        public final Builder organizationRuleMode(OrganizationRuleMode organizationRuleMode) {
            this.organizationRuleMode(organizationRuleMode == null ? null : organizationRuleMode.toString());
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        @Override
        public GetEnrollmentConfigurationResponse build() {
            return new GetEnrollmentConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnrollmentConfigurationResponse> {
        public Builder status(String var1);

        public Builder status(EnrollmentStatus var1);

        public Builder statusReason(String var1);

        public Builder organizationRuleMode(String var1);

        public Builder organizationRuleMode(OrganizationRuleMode var1);

        public Builder lastUpdatedTimestamp(Instant var1);
    }
}

