/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationAsyncClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.AutomationEventStep;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventStepsRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationEventStepsResponse;

public class ListAutomationEventStepsPublisher
implements SdkPublisher<ListAutomationEventStepsResponse> {
    private final ComputeOptimizerAutomationAsyncClient client;
    private final ListAutomationEventStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomationEventStepsPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationEventStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomationEventStepsPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationEventStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomationEventStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomationEventStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomationEventStep> automationEventSteps() {
        Function<ListAutomationEventStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationEventSteps() != null) {
                return response.automationEventSteps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomationEventStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomationEventStepsResponseFetcher
    implements AsyncPageFetcher<ListAutomationEventStepsResponse> {
        private ListAutomationEventStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationEventStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomationEventStepsResponse> nextPage(ListAutomationEventStepsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationEventStepsPublisher.this.client.listAutomationEventSteps(ListAutomationEventStepsPublisher.this.firstRequest);
            }
            return ListAutomationEventStepsPublisher.this.client.listAutomationEventSteps((ListAutomationEventStepsRequest)((Object)ListAutomationEventStepsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

