/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationAsyncClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulePreviewSummariesRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListAutomationRulePreviewSummariesResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.PreviewResultSummary;

public class ListAutomationRulePreviewSummariesPublisher
implements SdkPublisher<ListAutomationRulePreviewSummariesResponse> {
    private final ComputeOptimizerAutomationAsyncClient client;
    private final ListAutomationRulePreviewSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomationRulePreviewSummariesPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationRulePreviewSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomationRulePreviewSummariesPublisher(ComputeOptimizerAutomationAsyncClient client, ListAutomationRulePreviewSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomationRulePreviewSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomationRulePreviewSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PreviewResultSummary> previewResultSummaries() {
        Function<ListAutomationRulePreviewSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.previewResultSummaries() != null) {
                return response.previewResultSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomationRulePreviewSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomationRulePreviewSummariesResponseFetcher
    implements AsyncPageFetcher<ListAutomationRulePreviewSummariesResponse> {
        private ListAutomationRulePreviewSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomationRulePreviewSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomationRulePreviewSummariesResponse> nextPage(ListAutomationRulePreviewSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListAutomationRulePreviewSummariesPublisher.this.client.listAutomationRulePreviewSummaries(ListAutomationRulePreviewSummariesPublisher.this.firstRequest);
            }
            return ListAutomationRulePreviewSummariesPublisher.this.client.listAutomationRulePreviewSummaries((ListAutomationRulePreviewSummariesRequest)((Object)ListAutomationRulePreviewSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

