/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregateConformancePackComplianceFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregateConformancePackComplianceFilters> {
    private static final SdkField<String> CONFORMANCE_PACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConformancePackName").getter(AggregateConformancePackComplianceFilters.getter(AggregateConformancePackComplianceFilters::conformancePackName)).setter(AggregateConformancePackComplianceFilters.setter(Builder::conformancePackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConformancePackName").build()}).build();
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(AggregateConformancePackComplianceFilters.getter(AggregateConformancePackComplianceFilters::complianceTypeAsString)).setter(AggregateConformancePackComplianceFilters.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AggregateConformancePackComplianceFilters.getter(AggregateConformancePackComplianceFilters::accountId)).setter(AggregateConformancePackComplianceFilters.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsRegion").getter(AggregateConformancePackComplianceFilters.getter(AggregateConformancePackComplianceFilters::awsRegion)).setter(AggregateConformancePackComplianceFilters.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFORMANCE_PACK_NAME_FIELD, COMPLIANCE_TYPE_FIELD, ACCOUNT_ID_FIELD, AWS_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregateConformancePackComplianceFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String conformancePackName;
    private final String complianceType;
    private final String accountId;
    private final String awsRegion;

    private AggregateConformancePackComplianceFilters(BuilderImpl builder) {
        this.conformancePackName = builder.conformancePackName;
        this.complianceType = builder.complianceType;
        this.accountId = builder.accountId;
        this.awsRegion = builder.awsRegion;
    }

    public final String conformancePackName() {
        return this.conformancePackName;
    }

    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(this.complianceType);
    }

    public final String complianceTypeAsString() {
        return this.complianceType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conformancePackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateConformancePackComplianceFilters)) {
            return false;
        }
        AggregateConformancePackComplianceFilters other = (AggregateConformancePackComplianceFilters)obj;
        return Objects.equals(this.conformancePackName(), other.conformancePackName()) && Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.awsRegion(), other.awsRegion());
    }

    public final String toString() {
        return ToString.builder((String)"AggregateConformancePackComplianceFilters").add("ConformancePackName", (Object)this.conformancePackName()).add("ComplianceType", (Object)this.complianceTypeAsString()).add("AccountId", (Object)this.accountId()).add("AwsRegion", (Object)this.awsRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConformancePackName": {
                return Optional.ofNullable(clazz.cast(this.conformancePackName()));
            }
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AwsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConformancePackName", CONFORMANCE_PACK_NAME_FIELD);
        map.put("ComplianceType", COMPLIANCE_TYPE_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AwsRegion", AWS_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateConformancePackComplianceFilters, T> g) {
        return obj -> g.apply((AggregateConformancePackComplianceFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conformancePackName;
        private String complianceType;
        private String accountId;
        private String awsRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateConformancePackComplianceFilters model) {
            this.conformancePackName(model.conformancePackName);
            this.complianceType(model.complianceType);
            this.accountId(model.accountId);
            this.awsRegion(model.awsRegion);
        }

        public final String getConformancePackName() {
            return this.conformancePackName;
        }

        public final void setConformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
        }

        @Override
        public final Builder conformancePackName(String conformancePackName) {
            this.conformancePackName = conformancePackName;
            return this;
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public AggregateConformancePackComplianceFilters build() {
            return new AggregateConformancePackComplianceFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregateConformancePackComplianceFilters> {
        public Builder conformancePackName(String var1);

        public Builder complianceType(String var1);

        public Builder complianceType(ConformancePackComplianceType var1);

        public Builder accountId(String var1);

        public Builder awsRegion(String var1);
    }
}

