/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.EvaluationMode;
import software.amazon.awssdk.services.config.model.TimeWindow;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceEvaluationFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceEvaluationFilters> {
    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationMode").getter(ResourceEvaluationFilters.getter(ResourceEvaluationFilters::evaluationModeAsString)).setter(ResourceEvaluationFilters.setter(Builder::evaluationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()}).build();
    private static final SdkField<TimeWindow> TIME_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeWindow").getter(ResourceEvaluationFilters.getter(ResourceEvaluationFilters::timeWindow)).setter(ResourceEvaluationFilters.setter(Builder::timeWindow)).constructor(TimeWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeWindow").build()}).build();
    private static final SdkField<String> EVALUATION_CONTEXT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationContextIdentifier").getter(ResourceEvaluationFilters.getter(ResourceEvaluationFilters::evaluationContextIdentifier)).setter(ResourceEvaluationFilters.setter(Builder::evaluationContextIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationContextIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_MODE_FIELD, TIME_WINDOW_FIELD, EVALUATION_CONTEXT_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceEvaluationFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String evaluationMode;
    private final TimeWindow timeWindow;
    private final String evaluationContextIdentifier;

    private ResourceEvaluationFilters(BuilderImpl builder) {
        this.evaluationMode = builder.evaluationMode;
        this.timeWindow = builder.timeWindow;
        this.evaluationContextIdentifier = builder.evaluationContextIdentifier;
    }

    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(this.evaluationMode);
    }

    public final String evaluationModeAsString() {
        return this.evaluationMode;
    }

    public final TimeWindow timeWindow() {
        return this.timeWindow;
    }

    public final String evaluationContextIdentifier() {
        return this.evaluationContextIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationContextIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceEvaluationFilters)) {
            return false;
        }
        ResourceEvaluationFilters other = (ResourceEvaluationFilters)obj;
        return Objects.equals(this.evaluationModeAsString(), other.evaluationModeAsString()) && Objects.equals(this.timeWindow(), other.timeWindow()) && Objects.equals(this.evaluationContextIdentifier(), other.evaluationContextIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceEvaluationFilters").add("EvaluationMode", (Object)this.evaluationModeAsString()).add("TimeWindow", (Object)this.timeWindow()).add("EvaluationContextIdentifier", (Object)this.evaluationContextIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationMode": {
                return Optional.ofNullable(clazz.cast(this.evaluationModeAsString()));
            }
            case "TimeWindow": {
                return Optional.ofNullable(clazz.cast(this.timeWindow()));
            }
            case "EvaluationContextIdentifier": {
                return Optional.ofNullable(clazz.cast(this.evaluationContextIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationMode", EVALUATION_MODE_FIELD);
        map.put("TimeWindow", TIME_WINDOW_FIELD);
        map.put("EvaluationContextIdentifier", EVALUATION_CONTEXT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceEvaluationFilters, T> g) {
        return obj -> g.apply((ResourceEvaluationFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationMode;
        private TimeWindow timeWindow;
        private String evaluationContextIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceEvaluationFilters model) {
            this.evaluationMode(model.evaluationMode);
            this.timeWindow(model.timeWindow);
            this.evaluationContextIdentifier(model.evaluationContextIdentifier);
        }

        public final String getEvaluationMode() {
            return this.evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        public final TimeWindow.Builder getTimeWindow() {
            return this.timeWindow != null ? this.timeWindow.toBuilder() : null;
        }

        public final void setTimeWindow(TimeWindow.BuilderImpl timeWindow) {
            this.timeWindow = timeWindow != null ? timeWindow.build() : null;
        }

        @Override
        public final Builder timeWindow(TimeWindow timeWindow) {
            this.timeWindow = timeWindow;
            return this;
        }

        public final String getEvaluationContextIdentifier() {
            return this.evaluationContextIdentifier;
        }

        public final void setEvaluationContextIdentifier(String evaluationContextIdentifier) {
            this.evaluationContextIdentifier = evaluationContextIdentifier;
        }

        @Override
        public final Builder evaluationContextIdentifier(String evaluationContextIdentifier) {
            this.evaluationContextIdentifier = evaluationContextIdentifier;
            return this;
        }

        public ResourceEvaluationFilters build() {
            return new ResourceEvaluationFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceEvaluationFilters> {
        public Builder evaluationMode(String var1);

        public Builder evaluationMode(EvaluationMode var1);

        public Builder timeWindow(TimeWindow var1);

        default public Builder timeWindow(Consumer<TimeWindow.Builder> timeWindow) {
            return this.timeWindow((TimeWindow)((TimeWindow.Builder)TimeWindow.builder().applyMutation(timeWindow)).build());
        }

        public Builder evaluationContextIdentifier(String var1);
    }
}

