/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SsmControls
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SsmControls> {
    private static final SdkField<Integer> CONCURRENT_EXECUTION_RATE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConcurrentExecutionRatePercentage").getter(SsmControls.getter(SsmControls::concurrentExecutionRatePercentage)).setter(SsmControls.setter(Builder::concurrentExecutionRatePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConcurrentExecutionRatePercentage").build()}).build();
    private static final SdkField<Integer> ERROR_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ErrorPercentage").getter(SsmControls.getter(SsmControls::errorPercentage)).setter(SsmControls.setter(Builder::errorPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONCURRENT_EXECUTION_RATE_PERCENTAGE_FIELD, ERROR_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SsmControls.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer concurrentExecutionRatePercentage;
    private final Integer errorPercentage;

    private SsmControls(BuilderImpl builder) {
        this.concurrentExecutionRatePercentage = builder.concurrentExecutionRatePercentage;
        this.errorPercentage = builder.errorPercentage;
    }

    public final Integer concurrentExecutionRatePercentage() {
        return this.concurrentExecutionRatePercentage;
    }

    public final Integer errorPercentage() {
        return this.errorPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentExecutionRatePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmControls)) {
            return false;
        }
        SsmControls other = (SsmControls)obj;
        return Objects.equals(this.concurrentExecutionRatePercentage(), other.concurrentExecutionRatePercentage()) && Objects.equals(this.errorPercentage(), other.errorPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"SsmControls").add("ConcurrentExecutionRatePercentage", (Object)this.concurrentExecutionRatePercentage()).add("ErrorPercentage", (Object)this.errorPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConcurrentExecutionRatePercentage": {
                return Optional.ofNullable(clazz.cast(this.concurrentExecutionRatePercentage()));
            }
            case "ErrorPercentage": {
                return Optional.ofNullable(clazz.cast(this.errorPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("ConcurrentExecutionRatePercentage", CONCURRENT_EXECUTION_RATE_PERCENTAGE_FIELD);
        map.put("ErrorPercentage", ERROR_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SsmControls, T> g) {
        return obj -> g.apply((SsmControls)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer concurrentExecutionRatePercentage;
        private Integer errorPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(SsmControls model) {
            this.concurrentExecutionRatePercentage(model.concurrentExecutionRatePercentage);
            this.errorPercentage(model.errorPercentage);
        }

        public final Integer getConcurrentExecutionRatePercentage() {
            return this.concurrentExecutionRatePercentage;
        }

        public final void setConcurrentExecutionRatePercentage(Integer concurrentExecutionRatePercentage) {
            this.concurrentExecutionRatePercentage = concurrentExecutionRatePercentage;
        }

        @Override
        public final Builder concurrentExecutionRatePercentage(Integer concurrentExecutionRatePercentage) {
            this.concurrentExecutionRatePercentage = concurrentExecutionRatePercentage;
            return this;
        }

        public final Integer getErrorPercentage() {
            return this.errorPercentage;
        }

        public final void setErrorPercentage(Integer errorPercentage) {
            this.errorPercentage = errorPercentage;
        }

        @Override
        public final Builder errorPercentage(Integer errorPercentage) {
            this.errorPercentage = errorPercentage;
            return this;
        }

        public SsmControls build() {
            return new SsmControls(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SsmControls> {
        public Builder concurrentExecutionRatePercentage(Integer var1);

        public Builder errorPercentage(Integer var1);
    }
}

