/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataFormatValue {
    CSV("csv"),
    PARQUET("parquet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataFormatValue> VALUE_MAP;
    private final String value;

    private DataFormatValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataFormatValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataFormatValue> knownValues() {
        EnumSet<DataFormatValue> knownValues = EnumSet.allOf(DataFormatValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataFormatValue.class, DataFormatValue::toString);
    }
}

