/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsConfiguration> {
    private static final SdkField<String> ENGINE_EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineEdition").getter(RdsConfiguration.getter(RdsConfiguration::engineEdition)).setter(RdsConfiguration.setter(Builder::engineEdition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineEdition").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(RdsConfiguration.getter(RdsConfiguration::instanceType)).setter(RdsConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Double> INSTANCE_VCPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("InstanceVcpu").getter(RdsConfiguration.getter(RdsConfiguration::instanceVcpu)).setter(RdsConfiguration.setter(Builder::instanceVcpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceVcpu").build()}).build();
    private static final SdkField<Double> INSTANCE_MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("InstanceMemory").getter(RdsConfiguration.getter(RdsConfiguration::instanceMemory)).setter(RdsConfiguration.setter(Builder::instanceMemory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMemory").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(RdsConfiguration.getter(RdsConfiguration::storageType)).setter(RdsConfiguration.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Integer> STORAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageSize").getter(RdsConfiguration.getter(RdsConfiguration::storageSize)).setter(RdsConfiguration.setter(Builder::storageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSize").build()}).build();
    private static final SdkField<Integer> STORAGE_IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageIops").getter(RdsConfiguration.getter(RdsConfiguration::storageIops)).setter(RdsConfiguration.setter(Builder::storageIops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageIops").build()}).build();
    private static final SdkField<String> DEPLOYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentOption").getter(RdsConfiguration.getter(RdsConfiguration::deploymentOption)).setter(RdsConfiguration.setter(Builder::deploymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentOption").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(RdsConfiguration.getter(RdsConfiguration::engineVersion)).setter(RdsConfiguration.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_EDITION_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_VCPU_FIELD, INSTANCE_MEMORY_FIELD, STORAGE_TYPE_FIELD, STORAGE_SIZE_FIELD, STORAGE_IOPS_FIELD, DEPLOYMENT_OPTION_FIELD, ENGINE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RdsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String engineEdition;
    private final String instanceType;
    private final Double instanceVcpu;
    private final Double instanceMemory;
    private final String storageType;
    private final Integer storageSize;
    private final Integer storageIops;
    private final String deploymentOption;
    private final String engineVersion;

    private RdsConfiguration(BuilderImpl builder) {
        this.engineEdition = builder.engineEdition;
        this.instanceType = builder.instanceType;
        this.instanceVcpu = builder.instanceVcpu;
        this.instanceMemory = builder.instanceMemory;
        this.storageType = builder.storageType;
        this.storageSize = builder.storageSize;
        this.storageIops = builder.storageIops;
        this.deploymentOption = builder.deploymentOption;
        this.engineVersion = builder.engineVersion;
    }

    public final String engineEdition() {
        return this.engineEdition;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Double instanceVcpu() {
        return this.instanceVcpu;
    }

    public final Double instanceMemory() {
        return this.instanceMemory;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Integer storageSize() {
        return this.storageSize;
    }

    public final Integer storageIops() {
        return this.storageIops;
    }

    public final String deploymentOption() {
        return this.deploymentOption;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineEdition());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceVcpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMemory());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageIops());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsConfiguration)) {
            return false;
        }
        RdsConfiguration other = (RdsConfiguration)obj;
        return Objects.equals(this.engineEdition(), other.engineEdition()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceVcpu(), other.instanceVcpu()) && Objects.equals(this.instanceMemory(), other.instanceMemory()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.storageSize(), other.storageSize()) && Objects.equals(this.storageIops(), other.storageIops()) && Objects.equals(this.deploymentOption(), other.deploymentOption()) && Objects.equals(this.engineVersion(), other.engineVersion());
    }

    public final String toString() {
        return ToString.builder((String)"RdsConfiguration").add("EngineEdition", (Object)this.engineEdition()).add("InstanceType", (Object)this.instanceType()).add("InstanceVcpu", (Object)this.instanceVcpu()).add("InstanceMemory", (Object)this.instanceMemory()).add("StorageType", (Object)this.storageType()).add("StorageSize", (Object)this.storageSize()).add("StorageIops", (Object)this.storageIops()).add("DeploymentOption", (Object)this.deploymentOption()).add("EngineVersion", (Object)this.engineVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineEdition": {
                return Optional.ofNullable(clazz.cast(this.engineEdition()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstanceVcpu": {
                return Optional.ofNullable(clazz.cast(this.instanceVcpu()));
            }
            case "InstanceMemory": {
                return Optional.ofNullable(clazz.cast(this.instanceMemory()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "StorageSize": {
                return Optional.ofNullable(clazz.cast(this.storageSize()));
            }
            case "StorageIops": {
                return Optional.ofNullable(clazz.cast(this.storageIops()));
            }
            case "DeploymentOption": {
                return Optional.ofNullable(clazz.cast(this.deploymentOption()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EngineEdition", ENGINE_EDITION_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceVcpu", INSTANCE_VCPU_FIELD);
        map.put("InstanceMemory", INSTANCE_MEMORY_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("StorageSize", STORAGE_SIZE_FIELD);
        map.put("StorageIops", STORAGE_IOPS_FIELD);
        map.put("DeploymentOption", DEPLOYMENT_OPTION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsConfiguration, T> g) {
        return obj -> g.apply((RdsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineEdition;
        private String instanceType;
        private Double instanceVcpu;
        private Double instanceMemory;
        private String storageType;
        private Integer storageSize;
        private Integer storageIops;
        private String deploymentOption;
        private String engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsConfiguration model) {
            this.engineEdition(model.engineEdition);
            this.instanceType(model.instanceType);
            this.instanceVcpu(model.instanceVcpu);
            this.instanceMemory(model.instanceMemory);
            this.storageType(model.storageType);
            this.storageSize(model.storageSize);
            this.storageIops(model.storageIops);
            this.deploymentOption(model.deploymentOption);
            this.engineVersion(model.engineVersion);
        }

        public final String getEngineEdition() {
            return this.engineEdition;
        }

        public final void setEngineEdition(String engineEdition) {
            this.engineEdition = engineEdition;
        }

        @Override
        public final Builder engineEdition(String engineEdition) {
            this.engineEdition = engineEdition;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Double getInstanceVcpu() {
            return this.instanceVcpu;
        }

        public final void setInstanceVcpu(Double instanceVcpu) {
            this.instanceVcpu = instanceVcpu;
        }

        @Override
        public final Builder instanceVcpu(Double instanceVcpu) {
            this.instanceVcpu = instanceVcpu;
            return this;
        }

        public final Double getInstanceMemory() {
            return this.instanceMemory;
        }

        public final void setInstanceMemory(Double instanceMemory) {
            this.instanceMemory = instanceMemory;
        }

        @Override
        public final Builder instanceMemory(Double instanceMemory) {
            this.instanceMemory = instanceMemory;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getStorageSize() {
            return this.storageSize;
        }

        public final void setStorageSize(Integer storageSize) {
            this.storageSize = storageSize;
        }

        @Override
        public final Builder storageSize(Integer storageSize) {
            this.storageSize = storageSize;
            return this;
        }

        public final Integer getStorageIops() {
            return this.storageIops;
        }

        public final void setStorageIops(Integer storageIops) {
            this.storageIops = storageIops;
        }

        @Override
        public final Builder storageIops(Integer storageIops) {
            this.storageIops = storageIops;
            return this;
        }

        public final String getDeploymentOption() {
            return this.deploymentOption;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public RdsConfiguration build() {
            return new RdsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsConfiguration> {
        public Builder engineEdition(String var1);

        public Builder instanceType(String var1);

        public Builder instanceVcpu(Double var1);

        public Builder instanceMemory(Double var1);

        public Builder storageType(String var1);

        public Builder storageSize(Integer var1);

        public Builder storageIops(Integer var1);

        public Builder deploymentOption(String var1);

        public Builder engineVersion(String var1);
    }
}

