/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse;

public class DescribeFleetAdvisorCollectorsPublisher
implements SdkPublisher<DescribeFleetAdvisorCollectorsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeFleetAdvisorCollectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFleetAdvisorCollectorsPublisher(DatabaseMigrationAsyncClient client, DescribeFleetAdvisorCollectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFleetAdvisorCollectorsPublisher(DatabaseMigrationAsyncClient client, DescribeFleetAdvisorCollectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFleetAdvisorCollectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFleetAdvisorCollectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeFleetAdvisorCollectorsResponseFetcher
    implements AsyncPageFetcher<DescribeFleetAdvisorCollectorsResponse> {
        private DescribeFleetAdvisorCollectorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetAdvisorCollectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFleetAdvisorCollectorsResponse> nextPage(DescribeFleetAdvisorCollectorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetAdvisorCollectorsPublisher.this.client.describeFleetAdvisorCollectors(DescribeFleetAdvisorCollectorsPublisher.this.firstRequest);
            }
            return DescribeFleetAdvisorCollectorsPublisher.this.client.describeFleetAdvisorCollectors((DescribeFleetAdvisorCollectorsRequest)((Object)DescribeFleetAdvisorCollectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

