/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse;

public class DescribeMetadataModelConversionsPublisher
implements SdkPublisher<DescribeMetadataModelConversionsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeMetadataModelConversionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMetadataModelConversionsPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelConversionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMetadataModelConversionsPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelConversionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMetadataModelConversionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMetadataModelConversionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeMetadataModelConversionsResponseFetcher
    implements AsyncPageFetcher<DescribeMetadataModelConversionsResponse> {
        private DescribeMetadataModelConversionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelConversionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeMetadataModelConversionsResponse> nextPage(DescribeMetadataModelConversionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelConversionsPublisher.this.client.describeMetadataModelConversions(DescribeMetadataModelConversionsPublisher.this.firstRequest);
            }
            return DescribeMetadataModelConversionsPublisher.this.client.describeMetadataModelConversions((DescribeMetadataModelConversionsRequest)((Object)DescribeMetadataModelConversionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

