/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelCreationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelCreationsResponse;
import software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequest;

public class DescribeMetadataModelCreationsIterable
implements SdkIterable<DescribeMetadataModelCreationsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeMetadataModelCreationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMetadataModelCreationsIterable(DatabaseMigrationClient client, DescribeMetadataModelCreationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMetadataModelCreationsResponseFetcher();
    }

    public Iterator<DescribeMetadataModelCreationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SchemaConversionRequest> requests() {
        Function<DescribeMetadataModelCreationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.requests() != null) {
                return response.requests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMetadataModelCreationsResponseFetcher
    implements SyncPageFetcher<DescribeMetadataModelCreationsResponse> {
        private DescribeMetadataModelCreationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelCreationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeMetadataModelCreationsResponse nextPage(DescribeMetadataModelCreationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelCreationsIterable.this.client.describeMetadataModelCreations(DescribeMetadataModelCreationsIterable.this.firstRequest);
            }
            return DescribeMetadataModelCreationsIterable.this.client.describeMetadataModelCreations((DescribeMetadataModelCreationsRequest)((Object)DescribeMetadataModelCreationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

