/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelCreationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelCreationsResponse;
import software.amazon.awssdk.services.databasemigration.model.SchemaConversionRequest;

public class DescribeMetadataModelCreationsPublisher
implements SdkPublisher<DescribeMetadataModelCreationsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeMetadataModelCreationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMetadataModelCreationsPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelCreationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMetadataModelCreationsPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelCreationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMetadataModelCreationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMetadataModelCreationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SchemaConversionRequest> requests() {
        Function<DescribeMetadataModelCreationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.requests() != null) {
                return response.requests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMetadataModelCreationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMetadataModelCreationsResponseFetcher
    implements AsyncPageFetcher<DescribeMetadataModelCreationsResponse> {
        private DescribeMetadataModelCreationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelCreationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeMetadataModelCreationsResponse> nextPage(DescribeMetadataModelCreationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelCreationsPublisher.this.client.describeMetadataModelCreations(DescribeMetadataModelCreationsPublisher.this.firstRequest);
            }
            return DescribeMetadataModelCreationsPublisher.this.client.describeMetadataModelCreations((DescribeMetadataModelCreationsRequest)((Object)DescribeMetadataModelCreationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

