/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse;

public class DescribeMetadataModelExportsAsScriptPublisher
implements SdkPublisher<DescribeMetadataModelExportsAsScriptResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeMetadataModelExportsAsScriptRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMetadataModelExportsAsScriptPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelExportsAsScriptRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMetadataModelExportsAsScriptPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelExportsAsScriptRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMetadataModelExportsAsScriptResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMetadataModelExportsAsScriptResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeMetadataModelExportsAsScriptResponseFetcher
    implements AsyncPageFetcher<DescribeMetadataModelExportsAsScriptResponse> {
        private DescribeMetadataModelExportsAsScriptResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelExportsAsScriptResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeMetadataModelExportsAsScriptResponse> nextPage(DescribeMetadataModelExportsAsScriptResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelExportsAsScriptPublisher.this.client.describeMetadataModelExportsAsScript(DescribeMetadataModelExportsAsScriptPublisher.this.firstRequest);
            }
            return DescribeMetadataModelExportsAsScriptPublisher.this.client.describeMetadataModelExportsAsScript((DescribeMetadataModelExportsAsScriptRequest)((Object)DescribeMetadataModelExportsAsScriptPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

