/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse;

public class DescribeMetadataModelExportsToTargetIterable
implements SdkIterable<DescribeMetadataModelExportsToTargetResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeMetadataModelExportsToTargetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMetadataModelExportsToTargetIterable(DatabaseMigrationClient client, DescribeMetadataModelExportsToTargetRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMetadataModelExportsToTargetResponseFetcher();
    }

    public Iterator<DescribeMetadataModelExportsToTargetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeMetadataModelExportsToTargetResponseFetcher
    implements SyncPageFetcher<DescribeMetadataModelExportsToTargetResponse> {
        private DescribeMetadataModelExportsToTargetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelExportsToTargetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeMetadataModelExportsToTargetResponse nextPage(DescribeMetadataModelExportsToTargetResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelExportsToTargetIterable.this.client.describeMetadataModelExportsToTarget(DescribeMetadataModelExportsToTargetIterable.this.firstRequest);
            }
            return DescribeMetadataModelExportsToTargetIterable.this.client.describeMetadataModelExportsToTarget((DescribeMetadataModelExportsToTargetRequest)((Object)DescribeMetadataModelExportsToTargetIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

