/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse;

public class DescribeMetadataModelExportsToTargetPublisher
implements SdkPublisher<DescribeMetadataModelExportsToTargetResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeMetadataModelExportsToTargetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMetadataModelExportsToTargetPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelExportsToTargetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMetadataModelExportsToTargetPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelExportsToTargetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMetadataModelExportsToTargetResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMetadataModelExportsToTargetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeMetadataModelExportsToTargetResponseFetcher
    implements AsyncPageFetcher<DescribeMetadataModelExportsToTargetResponse> {
        private DescribeMetadataModelExportsToTargetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelExportsToTargetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeMetadataModelExportsToTargetResponse> nextPage(DescribeMetadataModelExportsToTargetResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelExportsToTargetPublisher.this.client.describeMetadataModelExportsToTarget(DescribeMetadataModelExportsToTargetPublisher.this.firstRequest);
            }
            return DescribeMetadataModelExportsToTargetPublisher.this.client.describeMetadataModelExportsToTarget((DescribeMetadataModelExportsToTargetRequest)((Object)DescribeMetadataModelExportsToTargetPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

