/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse;

public class DescribeRecommendationLimitationsIterable
implements SdkIterable<DescribeRecommendationLimitationsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeRecommendationLimitationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRecommendationLimitationsIterable(DatabaseMigrationClient client, DescribeRecommendationLimitationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRecommendationLimitationsResponseFetcher();
    }

    public Iterator<DescribeRecommendationLimitationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeRecommendationLimitationsResponseFetcher
    implements SyncPageFetcher<DescribeRecommendationLimitationsResponse> {
        private DescribeRecommendationLimitationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRecommendationLimitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRecommendationLimitationsResponse nextPage(DescribeRecommendationLimitationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRecommendationLimitationsIterable.this.client.describeRecommendationLimitations(DescribeRecommendationLimitationsIterable.this.firstRequest);
            }
            return DescribeRecommendationLimitationsIterable.this.client.describeRecommendationLimitations((DescribeRecommendationLimitationsRequest)((Object)DescribeRecommendationLimitationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

