/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse;

public class DescribeReplicationTableStatisticsIterable
implements SdkIterable<DescribeReplicationTableStatisticsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeReplicationTableStatisticsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationTableStatisticsIterable(DatabaseMigrationClient client, DescribeReplicationTableStatisticsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReplicationTableStatisticsResponseFetcher();
    }

    public Iterator<DescribeReplicationTableStatisticsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeReplicationTableStatisticsResponseFetcher
    implements SyncPageFetcher<DescribeReplicationTableStatisticsResponse> {
        private DescribeReplicationTableStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationTableStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReplicationTableStatisticsResponse nextPage(DescribeReplicationTableStatisticsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationTableStatisticsIterable.this.client.describeReplicationTableStatistics(DescribeReplicationTableStatisticsIterable.this.firstRequest);
            }
            return DescribeReplicationTableStatisticsIterable.this.client.describeReplicationTableStatistics((DescribeReplicationTableStatisticsRequest)((Object)DescribeReplicationTableStatisticsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

