/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datapipeline.model.PipelineObject;
import software.amazon.awssdk.services.datapipeline.model.PipelineObjectMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskObject> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(TaskObject.getter(TaskObject::taskId)).setter(TaskObject.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineId").getter(TaskObject.getter(TaskObject::pipelineId)).setter(TaskObject.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()}).build();
    private static final SdkField<String> ATTEMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attemptId").getter(TaskObject.getter(TaskObject::attemptId)).setter(TaskObject.setter(Builder::attemptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attemptId").build()}).build();
    private static final SdkField<Map<String, PipelineObject>> OBJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("objects").getter(TaskObject.getter(TaskObject::objects)).setter(TaskObject.setter(Builder::objects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objects").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, PIPELINE_ID_FIELD, ATTEMPT_ID_FIELD, OBJECTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskObject.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String pipelineId;
    private final String attemptId;
    private final Map<String, PipelineObject> objects;

    private TaskObject(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.pipelineId = builder.pipelineId;
        this.attemptId = builder.attemptId;
        this.objects = builder.objects;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String pipelineId() {
        return this.pipelineId;
    }

    public final String attemptId() {
        return this.attemptId;
    }

    public final boolean hasObjects() {
        return this.objects != null && !(this.objects instanceof SdkAutoConstructMap);
    }

    public final Map<String, PipelineObject> objects() {
        return this.objects;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attemptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjects() ? this.objects() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskObject)) {
            return false;
        }
        TaskObject other = (TaskObject)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.pipelineId(), other.pipelineId()) && Objects.equals(this.attemptId(), other.attemptId()) && this.hasObjects() == other.hasObjects() && Objects.equals(this.objects(), other.objects());
    }

    public final String toString() {
        return ToString.builder((String)"TaskObject").add("TaskId", (Object)this.taskId()).add("PipelineId", (Object)this.pipelineId()).add("AttemptId", (Object)this.attemptId()).add("Objects", this.hasObjects() ? this.objects() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "pipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "attemptId": {
                return Optional.ofNullable(clazz.cast(this.attemptId()));
            }
            case "objects": {
                return Optional.ofNullable(clazz.cast(this.objects()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", TASK_ID_FIELD);
        map.put("pipelineId", PIPELINE_ID_FIELD);
        map.put("attemptId", ATTEMPT_ID_FIELD);
        map.put("objects", OBJECTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskObject, T> g) {
        return obj -> g.apply((TaskObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String pipelineId;
        private String attemptId;
        private Map<String, PipelineObject> objects = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskObject model) {
            this.taskId(model.taskId);
            this.pipelineId(model.pipelineId);
            this.attemptId(model.attemptId);
            this.objects(model.objects);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final String getAttemptId() {
            return this.attemptId;
        }

        public final void setAttemptId(String attemptId) {
            this.attemptId = attemptId;
        }

        @Override
        public final Builder attemptId(String attemptId) {
            this.attemptId = attemptId;
            return this;
        }

        public final Map<String, PipelineObject.Builder> getObjects() {
            Map<String, PipelineObject.Builder> result = PipelineObjectMapCopier.copyToBuilder(this.objects);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setObjects(Map<String, PipelineObject.BuilderImpl> objects) {
            this.objects = PipelineObjectMapCopier.copyFromBuilder(objects);
        }

        @Override
        public final Builder objects(Map<String, PipelineObject> objects) {
            this.objects = PipelineObjectMapCopier.copy(objects);
            return this;
        }

        public TaskObject build() {
            return new TaskObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskObject> {
        public Builder taskId(String var1);

        public Builder pipelineId(String var1);

        public Builder attemptId(String var1);

        public Builder objects(Map<String, PipelineObject> var1);
    }
}

