/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.DrsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFailbackReplicationConfigurationRequest
extends DrsRequest
implements ToCopyableBuilder<Builder, UpdateFailbackReplicationConfigurationRequest> {
    private static final SdkField<Long> BANDWIDTH_THROTTLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bandwidthThrottling").getter(UpdateFailbackReplicationConfigurationRequest.getter(UpdateFailbackReplicationConfigurationRequest::bandwidthThrottling)).setter(UpdateFailbackReplicationConfigurationRequest.setter(Builder::bandwidthThrottling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthThrottling").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateFailbackReplicationConfigurationRequest.getter(UpdateFailbackReplicationConfigurationRequest::name)).setter(UpdateFailbackReplicationConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryInstanceID").getter(UpdateFailbackReplicationConfigurationRequest.getter(UpdateFailbackReplicationConfigurationRequest::recoveryInstanceID)).setter(UpdateFailbackReplicationConfigurationRequest.setter(Builder::recoveryInstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceID").build()}).build();
    private static final SdkField<Boolean> USE_PRIVATE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("usePrivateIP").getter(UpdateFailbackReplicationConfigurationRequest.getter(UpdateFailbackReplicationConfigurationRequest::usePrivateIP)).setter(UpdateFailbackReplicationConfigurationRequest.setter(Builder::usePrivateIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usePrivateIP").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_THROTTLING_FIELD, NAME_FIELD, RECOVERY_INSTANCE_ID_FIELD, USE_PRIVATE_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFailbackReplicationConfigurationRequest.memberNameToFieldInitializer();
    private final Long bandwidthThrottling;
    private final String name;
    private final String recoveryInstanceID;
    private final Boolean usePrivateIP;

    private UpdateFailbackReplicationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bandwidthThrottling = builder.bandwidthThrottling;
        this.name = builder.name;
        this.recoveryInstanceID = builder.recoveryInstanceID;
        this.usePrivateIP = builder.usePrivateIP;
    }

    public final Long bandwidthThrottling() {
        return this.bandwidthThrottling;
    }

    public final String name() {
        return this.name;
    }

    public final String recoveryInstanceID() {
        return this.recoveryInstanceID;
    }

    public final Boolean usePrivateIP() {
        return this.usePrivateIP;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidthThrottling());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.usePrivateIP());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFailbackReplicationConfigurationRequest)) {
            return false;
        }
        UpdateFailbackReplicationConfigurationRequest other = (UpdateFailbackReplicationConfigurationRequest)((Object)obj);
        return Objects.equals(this.bandwidthThrottling(), other.bandwidthThrottling()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recoveryInstanceID(), other.recoveryInstanceID()) && Objects.equals(this.usePrivateIP(), other.usePrivateIP());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFailbackReplicationConfigurationRequest").add("BandwidthThrottling", (Object)this.bandwidthThrottling()).add("Name", (Object)this.name()).add("RecoveryInstanceID", (Object)this.recoveryInstanceID()).add("UsePrivateIP", (Object)this.usePrivateIP()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bandwidthThrottling": {
                return Optional.ofNullable(clazz.cast(this.bandwidthThrottling()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recoveryInstanceID": {
                return Optional.ofNullable(clazz.cast(this.recoveryInstanceID()));
            }
            case "usePrivateIP": {
                return Optional.ofNullable(clazz.cast(this.usePrivateIP()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bandwidthThrottling", BANDWIDTH_THROTTLING_FIELD);
        map.put("name", NAME_FIELD);
        map.put("recoveryInstanceID", RECOVERY_INSTANCE_ID_FIELD);
        map.put("usePrivateIP", USE_PRIVATE_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFailbackReplicationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateFailbackReplicationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsRequest.BuilderImpl
    implements Builder {
        private Long bandwidthThrottling;
        private String name;
        private String recoveryInstanceID;
        private Boolean usePrivateIP;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFailbackReplicationConfigurationRequest model) {
            super(model);
            this.bandwidthThrottling(model.bandwidthThrottling);
            this.name(model.name);
            this.recoveryInstanceID(model.recoveryInstanceID);
            this.usePrivateIP(model.usePrivateIP);
        }

        public final Long getBandwidthThrottling() {
            return this.bandwidthThrottling;
        }

        public final void setBandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
        }

        @Override
        public final Builder bandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecoveryInstanceID() {
            return this.recoveryInstanceID;
        }

        public final void setRecoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
        }

        @Override
        public final Builder recoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
            return this;
        }

        public final Boolean getUsePrivateIP() {
            return this.usePrivateIP;
        }

        public final void setUsePrivateIP(Boolean usePrivateIP) {
            this.usePrivateIP = usePrivateIP;
        }

        @Override
        public final Builder usePrivateIP(Boolean usePrivateIP) {
            this.usePrivateIP = usePrivateIP;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFailbackReplicationConfigurationRequest build() {
            return new UpdateFailbackReplicationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DrsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFailbackReplicationConfigurationRequest> {
        public Builder bandwidthThrottling(Long var1);

        public Builder name(String var1);

        public Builder recoveryInstanceID(String var1);

        public Builder usePrivateIP(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

