/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsAsyncClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.Account;
import software.amazon.awssdk.services.drs.model.ListStagingAccountsRequest;
import software.amazon.awssdk.services.drs.model.ListStagingAccountsResponse;

public class ListStagingAccountsPublisher
implements SdkPublisher<ListStagingAccountsResponse> {
    private final DrsAsyncClient client;
    private final ListStagingAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStagingAccountsPublisher(DrsAsyncClient client, ListStagingAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStagingAccountsPublisher(DrsAsyncClient client, ListStagingAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStagingAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStagingAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Account> accounts() {
        Function<ListStagingAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accounts() != null) {
                return response.accounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStagingAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStagingAccountsResponseFetcher
    implements AsyncPageFetcher<ListStagingAccountsResponse> {
        private ListStagingAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListStagingAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStagingAccountsResponse> nextPage(ListStagingAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListStagingAccountsPublisher.this.client.listStagingAccounts(ListStagingAccountsPublisher.this.firstRequest);
            }
            return ListStagingAccountsPublisher.this.client.listStagingAccounts((ListStagingAccountsRequest)((Object)ListStagingAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

