/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dsql.model.DsqlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClusterPolicyResponse
extends DsqlResponse
implements ToCopyableBuilder<Builder, GetClusterPolicyResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policy").getter(GetClusterPolicyResponse.getter(GetClusterPolicyResponse::policy)).setter(GetClusterPolicyResponse.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<String> POLICY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyVersion").getter(GetClusterPolicyResponse.getter(GetClusterPolicyResponse::policyVersion)).setter(GetClusterPolicyResponse.setter(Builder::policyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, POLICY_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetClusterPolicyResponse.memberNameToFieldInitializer();
    private final String policy;
    private final String policyVersion;

    private GetClusterPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.policyVersion = builder.policyVersion;
    }

    public final String policy() {
        return this.policy;
    }

    public final String policyVersion() {
        return this.policyVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterPolicyResponse)) {
            return false;
        }
        GetClusterPolicyResponse other = (GetClusterPolicyResponse)((Object)obj);
        return Objects.equals(this.policy(), other.policy()) && Objects.equals(this.policyVersion(), other.policyVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetClusterPolicyResponse").add("Policy", (Object)this.policy()).add("PolicyVersion", (Object)this.policyVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "policyVersion": {
                return Optional.ofNullable(clazz.cast(this.policyVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("policy", POLICY_FIELD);
        map.put("policyVersion", POLICY_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClusterPolicyResponse, T> g) {
        return obj -> g.apply((GetClusterPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlResponse.BuilderImpl
    implements Builder {
        private String policy;
        private String policyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterPolicyResponse model) {
            super(model);
            this.policy(model.policy);
            this.policyVersion(model.policyVersion);
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getPolicyVersion() {
            return this.policyVersion;
        }

        public final void setPolicyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
        }

        @Override
        public final Builder policyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        @Override
        public GetClusterPolicyResponse build() {
            return new GetClusterPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DsqlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetClusterPolicyResponse> {
        public Builder policy(String var1);

        public Builder policyVersion(String var1);
    }
}

