/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecr.model.AnnotationsCopier;
import software.amazon.awssdk.services.ecr.model.ArtifactStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageReferrer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageReferrer> {
    private static final SdkField<String> DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("digest").getter(ImageReferrer.getter(ImageReferrer::digest)).setter(ImageReferrer.setter(Builder::digest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()}).build();
    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaType").getter(ImageReferrer.getter(ImageReferrer::mediaType)).setter(ImageReferrer.setter(Builder::mediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaType").build()}).build();
    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("artifactType").getter(ImageReferrer.getter(ImageReferrer::artifactType)).setter(ImageReferrer.setter(Builder::artifactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactType").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("size").getter(ImageReferrer.getter(ImageReferrer::size)).setter(ImageReferrer.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<Map<String, String>> ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("annotations").getter(ImageReferrer.getter(ImageReferrer::annotations)).setter(ImageReferrer.setter(Builder::annotations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ARTIFACT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("artifactStatus").getter(ImageReferrer.getter(ImageReferrer::artifactStatusAsString)).setter(ImageReferrer.setter(Builder::artifactStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIGEST_FIELD, MEDIA_TYPE_FIELD, ARTIFACT_TYPE_FIELD, SIZE_FIELD, ANNOTATIONS_FIELD, ARTIFACT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageReferrer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String digest;
    private final String mediaType;
    private final String artifactType;
    private final Long size;
    private final Map<String, String> annotations;
    private final String artifactStatus;

    private ImageReferrer(BuilderImpl builder) {
        this.digest = builder.digest;
        this.mediaType = builder.mediaType;
        this.artifactType = builder.artifactType;
        this.size = builder.size;
        this.annotations = builder.annotations;
        this.artifactStatus = builder.artifactStatus;
    }

    public final String digest() {
        return this.digest;
    }

    public final String mediaType() {
        return this.mediaType;
    }

    public final String artifactType() {
        return this.artifactType;
    }

    public final Long size() {
        return this.size;
    }

    public final boolean hasAnnotations() {
        return this.annotations != null && !(this.annotations instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> annotations() {
        return this.annotations;
    }

    public final ArtifactStatus artifactStatus() {
        return ArtifactStatus.fromValue(this.artifactStatus);
    }

    public final String artifactStatusAsString() {
        return this.artifactStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.digest());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactType());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotations() ? this.annotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageReferrer)) {
            return false;
        }
        ImageReferrer other = (ImageReferrer)obj;
        return Objects.equals(this.digest(), other.digest()) && Objects.equals(this.mediaType(), other.mediaType()) && Objects.equals(this.artifactType(), other.artifactType()) && Objects.equals(this.size(), other.size()) && this.hasAnnotations() == other.hasAnnotations() && Objects.equals(this.annotations(), other.annotations()) && Objects.equals(this.artifactStatusAsString(), other.artifactStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImageReferrer").add("Digest", (Object)this.digest()).add("MediaType", (Object)this.mediaType()).add("ArtifactType", (Object)this.artifactType()).add("Size", (Object)this.size()).add("Annotations", this.hasAnnotations() ? this.annotations() : null).add("ArtifactStatus", (Object)this.artifactStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "digest": {
                return Optional.ofNullable(clazz.cast(this.digest()));
            }
            case "mediaType": {
                return Optional.ofNullable(clazz.cast(this.mediaType()));
            }
            case "artifactType": {
                return Optional.ofNullable(clazz.cast(this.artifactType()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "annotations": {
                return Optional.ofNullable(clazz.cast(this.annotations()));
            }
            case "artifactStatus": {
                return Optional.ofNullable(clazz.cast(this.artifactStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("digest", DIGEST_FIELD);
        map.put("mediaType", MEDIA_TYPE_FIELD);
        map.put("artifactType", ARTIFACT_TYPE_FIELD);
        map.put("size", SIZE_FIELD);
        map.put("annotations", ANNOTATIONS_FIELD);
        map.put("artifactStatus", ARTIFACT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageReferrer, T> g) {
        return obj -> g.apply((ImageReferrer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String digest;
        private String mediaType;
        private String artifactType;
        private Long size;
        private Map<String, String> annotations = DefaultSdkAutoConstructMap.getInstance();
        private String artifactStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageReferrer model) {
            this.digest(model.digest);
            this.mediaType(model.mediaType);
            this.artifactType(model.artifactType);
            this.size(model.size);
            this.annotations(model.annotations);
            this.artifactStatus(model.artifactStatus);
        }

        public final String getDigest() {
            return this.digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final String getMediaType() {
            return this.mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final String getArtifactType() {
            return this.artifactType;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        @Override
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final Map<String, String> getAnnotations() {
            if (this.annotations instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.annotations;
        }

        public final void setAnnotations(Map<String, String> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
        }

        @Override
        public final Builder annotations(Map<String, String> annotations) {
            this.annotations = AnnotationsCopier.copy(annotations);
            return this;
        }

        public final String getArtifactStatus() {
            return this.artifactStatus;
        }

        public final void setArtifactStatus(String artifactStatus) {
            this.artifactStatus = artifactStatus;
        }

        @Override
        public final Builder artifactStatus(String artifactStatus) {
            this.artifactStatus = artifactStatus;
            return this;
        }

        @Override
        public final Builder artifactStatus(ArtifactStatus artifactStatus) {
            this.artifactStatus(artifactStatus == null ? null : artifactStatus.toString());
            return this;
        }

        public ImageReferrer build() {
            return new ImageReferrer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageReferrer> {
        public Builder digest(String var1);

        public Builder mediaType(String var1);

        public Builder artifactType(String var1);

        public Builder size(Long var1);

        public Builder annotations(Map<String, String> var1);

        public Builder artifactStatus(String var1);

        public Builder artifactStatus(ArtifactStatus var1);
    }
}

