/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CheckType {
    KEY_REUSE("KEY_REUSE"),
    KEY_COVERAGE("KEY_COVERAGE"),
    REACHABILITY("REACHABILITY"),
    HOST_COUNT("HOST_COUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CheckType> VALUE_MAP;
    private final String value;

    private CheckType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CheckType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CheckType> knownValues() {
        EnumSet<CheckType> knownValues = EnumSet.allOf(CheckType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CheckType.class, CheckType::toString);
    }
}

