/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.AccountIdListCopier;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAdminsManagingAccountResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, ListAdminsManagingAccountResponse> {
    private static final SdkField<List<String>> ADMIN_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdminAccounts").getter(ListAdminsManagingAccountResponse.getter(ListAdminsManagingAccountResponse::adminAccounts)).setter(ListAdminsManagingAccountResponse.setter(Builder::adminAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAdminsManagingAccountResponse.getter(ListAdminsManagingAccountResponse::nextToken)).setter(ListAdminsManagingAccountResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAdminsManagingAccountResponse.memberNameToFieldInitializer();
    private final List<String> adminAccounts;
    private final String nextToken;

    private ListAdminsManagingAccountResponse(BuilderImpl builder) {
        super(builder);
        this.adminAccounts = builder.adminAccounts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAdminAccounts() {
        return this.adminAccounts != null && !(this.adminAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> adminAccounts() {
        return this.adminAccounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdminAccounts() ? this.adminAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAdminsManagingAccountResponse)) {
            return false;
        }
        ListAdminsManagingAccountResponse other = (ListAdminsManagingAccountResponse)((Object)obj);
        return this.hasAdminAccounts() == other.hasAdminAccounts() && Objects.equals(this.adminAccounts(), other.adminAccounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAdminsManagingAccountResponse").add("AdminAccounts", this.hasAdminAccounts() ? this.adminAccounts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminAccounts": {
                return Optional.ofNullable(clazz.cast(this.adminAccounts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AdminAccounts", ADMIN_ACCOUNTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAdminsManagingAccountResponse, T> g) {
        return obj -> g.apply((ListAdminsManagingAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private List<String> adminAccounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAdminsManagingAccountResponse model) {
            super(model);
            this.adminAccounts(model.adminAccounts);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getAdminAccounts() {
            if (this.adminAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.adminAccounts;
        }

        public final void setAdminAccounts(Collection<String> adminAccounts) {
            this.adminAccounts = AccountIdListCopier.copy(adminAccounts);
        }

        @Override
        public final Builder adminAccounts(Collection<String> adminAccounts) {
            this.adminAccounts = AccountIdListCopier.copy(adminAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminAccounts(String ... adminAccounts) {
            this.adminAccounts(Arrays.asList(adminAccounts));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAdminsManagingAccountResponse build() {
            return new ListAdminsManagingAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAdminsManagingAccountResponse> {
        public Builder adminAccounts(Collection<String> var1);

        public Builder adminAccounts(String ... var1);

        public Builder nextToken(String var1);
    }
}

