/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.SecurityServiceType;
import software.amazon.awssdk.services.fms.model.SecurityServiceTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyTypeScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyTypeScope> {
    private static final SdkField<List<String>> POLICY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyTypes").getter(PolicyTypeScope.getter(PolicyTypeScope::policyTypesAsStrings)).setter(PolicyTypeScope.setter(Builder::policyTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALL_POLICY_TYPES_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllPolicyTypesEnabled").getter(PolicyTypeScope.getter(PolicyTypeScope::allPolicyTypesEnabled)).setter(PolicyTypeScope.setter(Builder::allPolicyTypesEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllPolicyTypesEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPES_FIELD, ALL_POLICY_TYPES_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PolicyTypeScope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> policyTypes;
    private final Boolean allPolicyTypesEnabled;

    private PolicyTypeScope(BuilderImpl builder) {
        this.policyTypes = builder.policyTypes;
        this.allPolicyTypesEnabled = builder.allPolicyTypesEnabled;
    }

    public final List<SecurityServiceType> policyTypes() {
        return SecurityServiceTypeListCopier.copyStringToEnum(this.policyTypes);
    }

    public final boolean hasPolicyTypes() {
        return this.policyTypes != null && !(this.policyTypes instanceof SdkAutoConstructList);
    }

    public final List<String> policyTypesAsStrings() {
        return this.policyTypes;
    }

    public final Boolean allPolicyTypesEnabled() {
        return this.allPolicyTypesEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyTypes() ? this.policyTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allPolicyTypesEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyTypeScope)) {
            return false;
        }
        PolicyTypeScope other = (PolicyTypeScope)obj;
        return this.hasPolicyTypes() == other.hasPolicyTypes() && Objects.equals(this.policyTypesAsStrings(), other.policyTypesAsStrings()) && Objects.equals(this.allPolicyTypesEnabled(), other.allPolicyTypesEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyTypeScope").add("PolicyTypes", this.hasPolicyTypes() ? this.policyTypesAsStrings() : null).add("AllPolicyTypesEnabled", (Object)this.allPolicyTypesEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyTypes": {
                return Optional.ofNullable(clazz.cast(this.policyTypesAsStrings()));
            }
            case "AllPolicyTypesEnabled": {
                return Optional.ofNullable(clazz.cast(this.allPolicyTypesEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyTypes", POLICY_TYPES_FIELD);
        map.put("AllPolicyTypesEnabled", ALL_POLICY_TYPES_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyTypeScope, T> g) {
        return obj -> g.apply((PolicyTypeScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> policyTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean allPolicyTypesEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyTypeScope model) {
            this.policyTypesWithStrings(model.policyTypes);
            this.allPolicyTypesEnabled(model.allPolicyTypesEnabled);
        }

        public final Collection<String> getPolicyTypes() {
            if (this.policyTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyTypes;
        }

        public final void setPolicyTypes(Collection<String> policyTypes) {
            this.policyTypes = SecurityServiceTypeListCopier.copy(policyTypes);
        }

        @Override
        public final Builder policyTypesWithStrings(Collection<String> policyTypes) {
            this.policyTypes = SecurityServiceTypeListCopier.copy(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypesWithStrings(String ... policyTypes) {
            this.policyTypesWithStrings(Arrays.asList(policyTypes));
            return this;
        }

        @Override
        public final Builder policyTypes(Collection<SecurityServiceType> policyTypes) {
            this.policyTypes = SecurityServiceTypeListCopier.copyEnumToString(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(SecurityServiceType ... policyTypes) {
            this.policyTypes(Arrays.asList(policyTypes));
            return this;
        }

        public final Boolean getAllPolicyTypesEnabled() {
            return this.allPolicyTypesEnabled;
        }

        public final void setAllPolicyTypesEnabled(Boolean allPolicyTypesEnabled) {
            this.allPolicyTypesEnabled = allPolicyTypesEnabled;
        }

        @Override
        public final Builder allPolicyTypesEnabled(Boolean allPolicyTypesEnabled) {
            this.allPolicyTypesEnabled = allPolicyTypesEnabled;
            return this;
        }

        public PolicyTypeScope build() {
            return new PolicyTypeScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyTypeScope> {
        public Builder policyTypesWithStrings(Collection<String> var1);

        public Builder policyTypesWithStrings(String ... var1);

        public Builder policyTypes(Collection<SecurityServiceType> var1);

        public Builder policyTypes(SecurityServiceType ... var1);

        public Builder allPolicyTypesEnabled(Boolean var1);
    }
}

