/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.endpoints;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class GameLiftStreamsEndpointParams
implements ToCopyableBuilder<Builder, GameLiftStreamsEndpointParams> {
    private final Boolean useFIPS;
    private final String endpoint;
    private final Region region;

    private GameLiftStreamsEndpointParams(BuilderImpl builder) {
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.region = builder.region;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Boolean useFips() {
        return this.useFIPS;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public Region region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    private static class BuilderImpl
    implements Builder {
        private Boolean useFIPS = false;
        private String endpoint;
        private Region region;

        private BuilderImpl() {
        }

        private BuilderImpl(GameLiftStreamsEndpointParams builder) {
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.region = builder.region;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public GameLiftStreamsEndpointParams build() {
            return new GameLiftStreamsEndpointParams(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GameLiftStreamsEndpointParams> {
        public Builder useFips(Boolean var1);

        public Builder endpoint(String var1);

        public Builder region(Region var1);

        public GameLiftStreamsEndpointParams build();
    }
}

