/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gameliftstreams.model.DefaultApplication;
import software.amazon.awssdk.services.gameliftstreams.model.StreamClass;
import software.amazon.awssdk.services.gameliftstreams.model.StreamGroupStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamGroupSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamGroupSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(StreamGroupSummary.getter(StreamGroupSummary::arn)).setter(StreamGroupSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(StreamGroupSummary.getter(StreamGroupSummary::id)).setter(StreamGroupSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StreamGroupSummary.getter(StreamGroupSummary::description)).setter(StreamGroupSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<DefaultApplication> DEFAULT_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultApplication").getter(StreamGroupSummary.getter(StreamGroupSummary::defaultApplication)).setter(StreamGroupSummary.setter(Builder::defaultApplication)).constructor(DefaultApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultApplication").build()}).build();
    private static final SdkField<String> STREAM_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamClass").getter(StreamGroupSummary.getter(StreamGroupSummary::streamClassAsString)).setter(StreamGroupSummary.setter(Builder::streamClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamClass").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StreamGroupSummary.getter(StreamGroupSummary::statusAsString)).setter(StreamGroupSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(StreamGroupSummary.getter(StreamGroupSummary::createdAt)).setter(StreamGroupSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(StreamGroupSummary.getter(StreamGroupSummary::lastUpdatedAt)).setter(StreamGroupSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiresAt").getter(StreamGroupSummary.getter(StreamGroupSummary::expiresAt)).setter(StreamGroupSummary.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, DESCRIPTION_FIELD, DEFAULT_APPLICATION_FIELD, STREAM_CLASS_FIELD, STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, EXPIRES_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamGroupSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String description;
    private final DefaultApplication defaultApplication;
    private final String streamClass;
    private final String status;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Instant expiresAt;

    private StreamGroupSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.description = builder.description;
        this.defaultApplication = builder.defaultApplication;
        this.streamClass = builder.streamClass;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.expiresAt = builder.expiresAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final DefaultApplication defaultApplication() {
        return this.defaultApplication;
    }

    public final StreamClass streamClass() {
        return StreamClass.fromValue(this.streamClass);
    }

    public final String streamClassAsString() {
        return this.streamClass;
    }

    public final StreamGroupStatus status() {
        return StreamGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamGroupSummary)) {
            return false;
        }
        StreamGroupSummary other = (StreamGroupSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultApplication(), other.defaultApplication()) && Objects.equals(this.streamClassAsString(), other.streamClassAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.expiresAt(), other.expiresAt());
    }

    public final String toString() {
        return ToString.builder((String)"StreamGroupSummary").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("DefaultApplication", (Object)this.defaultApplication()).add("StreamClass", (Object)this.streamClassAsString()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ExpiresAt", (Object)this.expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultApplication": {
                return Optional.ofNullable(clazz.cast(this.defaultApplication()));
            }
            case "StreamClass": {
                return Optional.ofNullable(clazz.cast(this.streamClassAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "ExpiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DefaultApplication", DEFAULT_APPLICATION_FIELD);
        map.put("StreamClass", STREAM_CLASS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("ExpiresAt", EXPIRES_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamGroupSummary, T> g) {
        return obj -> g.apply((StreamGroupSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String description;
        private DefaultApplication defaultApplication;
        private String streamClass;
        private String status;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamGroupSummary model) {
            this.arn(model.arn);
            this.id(model.id);
            this.description(model.description);
            this.defaultApplication(model.defaultApplication);
            this.streamClass(model.streamClass);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.expiresAt(model.expiresAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DefaultApplication.Builder getDefaultApplication() {
            return this.defaultApplication != null ? this.defaultApplication.toBuilder() : null;
        }

        public final void setDefaultApplication(DefaultApplication.BuilderImpl defaultApplication) {
            this.defaultApplication = defaultApplication != null ? defaultApplication.build() : null;
        }

        @Override
        public final Builder defaultApplication(DefaultApplication defaultApplication) {
            this.defaultApplication = defaultApplication;
            return this;
        }

        public final String getStreamClass() {
            return this.streamClass;
        }

        public final void setStreamClass(String streamClass) {
            this.streamClass = streamClass;
        }

        @Override
        public final Builder streamClass(String streamClass) {
            this.streamClass = streamClass;
            return this;
        }

        @Override
        public final Builder streamClass(StreamClass streamClass) {
            this.streamClass(streamClass == null ? null : streamClass.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public StreamGroupSummary build() {
            return new StreamGroupSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamGroupSummary> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder description(String var1);

        public Builder defaultApplication(DefaultApplication var1);

        default public Builder defaultApplication(Consumer<DefaultApplication.Builder> defaultApplication) {
            return this.defaultApplication((DefaultApplication)((DefaultApplication.Builder)DefaultApplication.builder().applyMutation(defaultApplication)).build());
        }

        public Builder streamClass(String var1);

        public Builder streamClass(StreamClass var1);

        public Builder status(String var1);

        public Builder status(StreamGroupStatus var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder expiresAt(Instant var1);
    }
}

