/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.grafana.model.GrafanaResponse;
import software.amazon.awssdk.services.grafana.model.ServiceAccountTokenSummaryWithKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspaceServiceAccountTokenResponse
extends GrafanaResponse
implements ToCopyableBuilder<Builder, CreateWorkspaceServiceAccountTokenResponse> {
    private static final SdkField<String> SERVICE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceAccountId").getter(CreateWorkspaceServiceAccountTokenResponse.getter(CreateWorkspaceServiceAccountTokenResponse::serviceAccountId)).setter(CreateWorkspaceServiceAccountTokenResponse.setter(Builder::serviceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountId").build()}).build();
    private static final SdkField<ServiceAccountTokenSummaryWithKey> SERVICE_ACCOUNT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceAccountToken").getter(CreateWorkspaceServiceAccountTokenResponse.getter(CreateWorkspaceServiceAccountTokenResponse::serviceAccountToken)).setter(CreateWorkspaceServiceAccountTokenResponse.setter(Builder::serviceAccountToken)).constructor(ServiceAccountTokenSummaryWithKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceAccountToken").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(CreateWorkspaceServiceAccountTokenResponse.getter(CreateWorkspaceServiceAccountTokenResponse::workspaceId)).setter(CreateWorkspaceServiceAccountTokenResponse.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCOUNT_ID_FIELD, SERVICE_ACCOUNT_TOKEN_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWorkspaceServiceAccountTokenResponse.memberNameToFieldInitializer();
    private final String serviceAccountId;
    private final ServiceAccountTokenSummaryWithKey serviceAccountToken;
    private final String workspaceId;

    private CreateWorkspaceServiceAccountTokenResponse(BuilderImpl builder) {
        super(builder);
        this.serviceAccountId = builder.serviceAccountId;
        this.serviceAccountToken = builder.serviceAccountToken;
        this.workspaceId = builder.workspaceId;
    }

    public final String serviceAccountId() {
        return this.serviceAccountId;
    }

    public final ServiceAccountTokenSummaryWithKey serviceAccountToken() {
        return this.serviceAccountToken;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceServiceAccountTokenResponse)) {
            return false;
        }
        CreateWorkspaceServiceAccountTokenResponse other = (CreateWorkspaceServiceAccountTokenResponse)((Object)obj);
        return Objects.equals(this.serviceAccountId(), other.serviceAccountId()) && Objects.equals(this.serviceAccountToken(), other.serviceAccountToken()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkspaceServiceAccountTokenResponse").add("ServiceAccountId", (Object)this.serviceAccountId()).add("ServiceAccountToken", (Object)this.serviceAccountToken()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceAccountId": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountId()));
            }
            case "serviceAccountToken": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountToken()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceAccountId", SERVICE_ACCOUNT_ID_FIELD);
        map.put("serviceAccountToken", SERVICE_ACCOUNT_TOKEN_FIELD);
        map.put("workspaceId", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceServiceAccountTokenResponse, T> g) {
        return obj -> g.apply((CreateWorkspaceServiceAccountTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaResponse.BuilderImpl
    implements Builder {
        private String serviceAccountId;
        private ServiceAccountTokenSummaryWithKey serviceAccountToken;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceServiceAccountTokenResponse model) {
            super(model);
            this.serviceAccountId(model.serviceAccountId);
            this.serviceAccountToken(model.serviceAccountToken);
            this.workspaceId(model.workspaceId);
        }

        public final String getServiceAccountId() {
            return this.serviceAccountId;
        }

        public final void setServiceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
        }

        @Override
        public final Builder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public final ServiceAccountTokenSummaryWithKey.Builder getServiceAccountToken() {
            return this.serviceAccountToken != null ? this.serviceAccountToken.toBuilder() : null;
        }

        public final void setServiceAccountToken(ServiceAccountTokenSummaryWithKey.BuilderImpl serviceAccountToken) {
            this.serviceAccountToken = serviceAccountToken != null ? serviceAccountToken.build() : null;
        }

        @Override
        public final Builder serviceAccountToken(ServiceAccountTokenSummaryWithKey serviceAccountToken) {
            this.serviceAccountToken = serviceAccountToken;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public CreateWorkspaceServiceAccountTokenResponse build() {
            return new CreateWorkspaceServiceAccountTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GrafanaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspaceServiceAccountTokenResponse> {
        public Builder serviceAccountId(String var1);

        public Builder serviceAccountToken(ServiceAccountTokenSummaryWithKey var1);

        default public Builder serviceAccountToken(Consumer<ServiceAccountTokenSummaryWithKey.Builder> serviceAccountToken) {
            return this.serviceAccountToken((ServiceAccountTokenSummaryWithKey)((ServiceAccountTokenSummaryWithKey.Builder)ServiceAccountTokenSummaryWithKey.builder().applyMutation(serviceAccountToken)).build());
        }

        public Builder workspaceId(String var1);
    }
}

