/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.SignalValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanSignal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanSignal> {
    private static final SdkField<Integer> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("messageId").getter(CanSignal.getter(CanSignal::messageId)).setter(CanSignal.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()}).build();
    private static final SdkField<Boolean> IS_BIG_ENDIAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isBigEndian").getter(CanSignal.getter(CanSignal::isBigEndian)).setter(CanSignal.setter(Builder::isBigEndian)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isBigEndian").build()}).build();
    private static final SdkField<Boolean> IS_SIGNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSigned").getter(CanSignal.getter(CanSignal::isSigned)).setter(CanSignal.setter(Builder::isSigned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSigned").build()}).build();
    private static final SdkField<Integer> START_BIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("startBit").getter(CanSignal.getter(CanSignal::startBit)).setter(CanSignal.setter(Builder::startBit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startBit").build()}).build();
    private static final SdkField<Double> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("offset").getter(CanSignal.getter(CanSignal::offset)).setter(CanSignal.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()}).build();
    private static final SdkField<Double> FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("factor").getter(CanSignal.getter(CanSignal::factor)).setter(CanSignal.setter(Builder::factor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("factor").build()}).build();
    private static final SdkField<Integer> LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("length").getter(CanSignal.getter(CanSignal::length)).setter(CanSignal.setter(Builder::length)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("length").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CanSignal.getter(CanSignal::name)).setter(CanSignal.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SIGNAL_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signalValueType").getter(CanSignal.getter(CanSignal::signalValueTypeAsString)).setter(CanSignal.setter(Builder::signalValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalValueType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, IS_BIG_ENDIAN_FIELD, IS_SIGNED_FIELD, START_BIT_FIELD, OFFSET_FIELD, FACTOR_FIELD, LENGTH_FIELD, NAME_FIELD, SIGNAL_VALUE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CanSignal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer messageId;
    private final Boolean isBigEndian;
    private final Boolean isSigned;
    private final Integer startBit;
    private final Double offset;
    private final Double factor;
    private final Integer length;
    private final String name;
    private final String signalValueType;

    private CanSignal(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.isBigEndian = builder.isBigEndian;
        this.isSigned = builder.isSigned;
        this.startBit = builder.startBit;
        this.offset = builder.offset;
        this.factor = builder.factor;
        this.length = builder.length;
        this.name = builder.name;
        this.signalValueType = builder.signalValueType;
    }

    public final Integer messageId() {
        return this.messageId;
    }

    public final Boolean isBigEndian() {
        return this.isBigEndian;
    }

    public final Boolean isSigned() {
        return this.isSigned;
    }

    public final Integer startBit() {
        return this.startBit;
    }

    public final Double offset() {
        return this.offset;
    }

    public final Double factor() {
        return this.factor;
    }

    public final Integer length() {
        return this.length;
    }

    public final String name() {
        return this.name;
    }

    public final SignalValueType signalValueType() {
        return SignalValueType.fromValue(this.signalValueType);
    }

    public final String signalValueTypeAsString() {
        return this.signalValueType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isBigEndian());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSigned());
        hashCode = 31 * hashCode + Objects.hashCode(this.startBit());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.factor());
        hashCode = 31 * hashCode + Objects.hashCode(this.length());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalValueTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanSignal)) {
            return false;
        }
        CanSignal other = (CanSignal)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.isBigEndian(), other.isBigEndian()) && Objects.equals(this.isSigned(), other.isSigned()) && Objects.equals(this.startBit(), other.startBit()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.factor(), other.factor()) && Objects.equals(this.length(), other.length()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.signalValueTypeAsString(), other.signalValueTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CanSignal").add("MessageId", (Object)this.messageId()).add("IsBigEndian", (Object)this.isBigEndian()).add("IsSigned", (Object)this.isSigned()).add("StartBit", (Object)this.startBit()).add("Offset", (Object)this.offset()).add("Factor", (Object)this.factor()).add("Length", (Object)this.length()).add("Name", (Object)this.name()).add("SignalValueType", (Object)this.signalValueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "isBigEndian": {
                return Optional.ofNullable(clazz.cast(this.isBigEndian()));
            }
            case "isSigned": {
                return Optional.ofNullable(clazz.cast(this.isSigned()));
            }
            case "startBit": {
                return Optional.ofNullable(clazz.cast(this.startBit()));
            }
            case "offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "factor": {
                return Optional.ofNullable(clazz.cast(this.factor()));
            }
            case "length": {
                return Optional.ofNullable(clazz.cast(this.length()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "signalValueType": {
                return Optional.ofNullable(clazz.cast(this.signalValueTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("isBigEndian", IS_BIG_ENDIAN_FIELD);
        map.put("isSigned", IS_SIGNED_FIELD);
        map.put("startBit", START_BIT_FIELD);
        map.put("offset", OFFSET_FIELD);
        map.put("factor", FACTOR_FIELD);
        map.put("length", LENGTH_FIELD);
        map.put("name", NAME_FIELD);
        map.put("signalValueType", SIGNAL_VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanSignal, T> g) {
        return obj -> g.apply((CanSignal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer messageId;
        private Boolean isBigEndian;
        private Boolean isSigned;
        private Integer startBit;
        private Double offset;
        private Double factor;
        private Integer length;
        private String name;
        private String signalValueType;

        private BuilderImpl() {
        }

        private BuilderImpl(CanSignal model) {
            this.messageId(model.messageId);
            this.isBigEndian(model.isBigEndian);
            this.isSigned(model.isSigned);
            this.startBit(model.startBit);
            this.offset(model.offset);
            this.factor(model.factor);
            this.length(model.length);
            this.name(model.name);
            this.signalValueType(model.signalValueType);
        }

        public final Integer getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(Integer messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Boolean getIsBigEndian() {
            return this.isBigEndian;
        }

        public final void setIsBigEndian(Boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
        }

        @Override
        public final Builder isBigEndian(Boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
            return this;
        }

        public final Boolean getIsSigned() {
            return this.isSigned;
        }

        public final void setIsSigned(Boolean isSigned) {
            this.isSigned = isSigned;
        }

        @Override
        public final Builder isSigned(Boolean isSigned) {
            this.isSigned = isSigned;
            return this;
        }

        public final Integer getStartBit() {
            return this.startBit;
        }

        public final void setStartBit(Integer startBit) {
            this.startBit = startBit;
        }

        @Override
        public final Builder startBit(Integer startBit) {
            this.startBit = startBit;
            return this;
        }

        public final Double getOffset() {
            return this.offset;
        }

        public final void setOffset(Double offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Double offset) {
            this.offset = offset;
            return this;
        }

        public final Double getFactor() {
            return this.factor;
        }

        public final void setFactor(Double factor) {
            this.factor = factor;
        }

        @Override
        public final Builder factor(Double factor) {
            this.factor = factor;
            return this;
        }

        public final Integer getLength() {
            return this.length;
        }

        public final void setLength(Integer length) {
            this.length = length;
        }

        @Override
        public final Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSignalValueType() {
            return this.signalValueType;
        }

        public final void setSignalValueType(String signalValueType) {
            this.signalValueType = signalValueType;
        }

        @Override
        public final Builder signalValueType(String signalValueType) {
            this.signalValueType = signalValueType;
            return this;
        }

        @Override
        public final Builder signalValueType(SignalValueType signalValueType) {
            this.signalValueType(signalValueType == null ? null : signalValueType.toString());
            return this;
        }

        public CanSignal build() {
            return new CanSignal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanSignal> {
        public Builder messageId(Integer var1);

        public Builder isBigEndian(Boolean var1);

        public Builder isSigned(Boolean var1);

        public Builder startBit(Integer var1);

        public Builder offset(Double var1);

        public Builder factor(Double var1);

        public Builder length(Integer var1);

        public Builder name(String var1);

        public Builder signalValueType(String var1);

        public Builder signalValueType(SignalValueType var1);
    }
}

