/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.ROS2PrimitiveType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ROS2PrimitiveMessageDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ROS2PrimitiveMessageDefinition> {
    private static final SdkField<String> PRIMITIVE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("primitiveType").getter(ROS2PrimitiveMessageDefinition.getter(ROS2PrimitiveMessageDefinition::primitiveTypeAsString)).setter(ROS2PrimitiveMessageDefinition.setter(Builder::primitiveType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primitiveType").build()}).build();
    private static final SdkField<Double> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("offset").getter(ROS2PrimitiveMessageDefinition.getter(ROS2PrimitiveMessageDefinition::offset)).setter(ROS2PrimitiveMessageDefinition.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()}).build();
    private static final SdkField<Double> SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("scaling").getter(ROS2PrimitiveMessageDefinition.getter(ROS2PrimitiveMessageDefinition::scaling)).setter(ROS2PrimitiveMessageDefinition.setter(Builder::scaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scaling").build()}).build();
    private static final SdkField<Long> UPPER_BOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("upperBound").getter(ROS2PrimitiveMessageDefinition.getter(ROS2PrimitiveMessageDefinition::upperBound)).setter(ROS2PrimitiveMessageDefinition.setter(Builder::upperBound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upperBound").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMITIVE_TYPE_FIELD, OFFSET_FIELD, SCALING_FIELD, UPPER_BOUND_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ROS2PrimitiveMessageDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String primitiveType;
    private final Double offset;
    private final Double scaling;
    private final Long upperBound;

    private ROS2PrimitiveMessageDefinition(BuilderImpl builder) {
        this.primitiveType = builder.primitiveType;
        this.offset = builder.offset;
        this.scaling = builder.scaling;
        this.upperBound = builder.upperBound;
    }

    public final ROS2PrimitiveType primitiveType() {
        return ROS2PrimitiveType.fromValue(this.primitiveType);
    }

    public final String primitiveTypeAsString() {
        return this.primitiveType;
    }

    public final Double offset() {
        return this.offset;
    }

    public final Double scaling() {
        return this.scaling;
    }

    public final Long upperBound() {
        return this.upperBound;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primitiveTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.upperBound());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ROS2PrimitiveMessageDefinition)) {
            return false;
        }
        ROS2PrimitiveMessageDefinition other = (ROS2PrimitiveMessageDefinition)obj;
        return Objects.equals(this.primitiveTypeAsString(), other.primitiveTypeAsString()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.scaling(), other.scaling()) && Objects.equals(this.upperBound(), other.upperBound());
    }

    public final String toString() {
        return ToString.builder((String)"ROS2PrimitiveMessageDefinition").add("PrimitiveType", (Object)this.primitiveTypeAsString()).add("Offset", (Object)this.offset()).add("Scaling", (Object)this.scaling()).add("UpperBound", (Object)this.upperBound()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "primitiveType": {
                return Optional.ofNullable(clazz.cast(this.primitiveTypeAsString()));
            }
            case "offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "scaling": {
                return Optional.ofNullable(clazz.cast(this.scaling()));
            }
            case "upperBound": {
                return Optional.ofNullable(clazz.cast(this.upperBound()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("primitiveType", PRIMITIVE_TYPE_FIELD);
        map.put("offset", OFFSET_FIELD);
        map.put("scaling", SCALING_FIELD);
        map.put("upperBound", UPPER_BOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ROS2PrimitiveMessageDefinition, T> g) {
        return obj -> g.apply((ROS2PrimitiveMessageDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primitiveType;
        private Double offset;
        private Double scaling;
        private Long upperBound;

        private BuilderImpl() {
        }

        private BuilderImpl(ROS2PrimitiveMessageDefinition model) {
            this.primitiveType(model.primitiveType);
            this.offset(model.offset);
            this.scaling(model.scaling);
            this.upperBound(model.upperBound);
        }

        public final String getPrimitiveType() {
            return this.primitiveType;
        }

        public final void setPrimitiveType(String primitiveType) {
            this.primitiveType = primitiveType;
        }

        @Override
        public final Builder primitiveType(String primitiveType) {
            this.primitiveType = primitiveType;
            return this;
        }

        @Override
        public final Builder primitiveType(ROS2PrimitiveType primitiveType) {
            this.primitiveType(primitiveType == null ? null : primitiveType.toString());
            return this;
        }

        public final Double getOffset() {
            return this.offset;
        }

        public final void setOffset(Double offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Double offset) {
            this.offset = offset;
            return this;
        }

        public final Double getScaling() {
            return this.scaling;
        }

        public final void setScaling(Double scaling) {
            this.scaling = scaling;
        }

        @Override
        public final Builder scaling(Double scaling) {
            this.scaling = scaling;
            return this;
        }

        public final Long getUpperBound() {
            return this.upperBound;
        }

        public final void setUpperBound(Long upperBound) {
            this.upperBound = upperBound;
        }

        @Override
        public final Builder upperBound(Long upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public ROS2PrimitiveMessageDefinition build() {
            return new ROS2PrimitiveMessageDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ROS2PrimitiveMessageDefinition> {
        public Builder primitiveType(String var1);

        public Builder primitiveType(ROS2PrimitiveType var1);

        public Builder offset(Double var1);

        public Builder scaling(Double var1);

        public Builder upperBound(Long var1);
    }
}

