/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ROS2PrimitiveType {
    BOOL("BOOL"),
    BYTE("BYTE"),
    CHAR("CHAR"),
    FLOAT32("FLOAT32"),
    FLOAT64("FLOAT64"),
    INT8("INT8"),
    UINT8("UINT8"),
    INT16("INT16"),
    UINT16("UINT16"),
    INT32("INT32"),
    UINT32("UINT32"),
    INT64("INT64"),
    UINT64("UINT64"),
    STRING("STRING"),
    WSTRING("WSTRING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ROS2PrimitiveType> VALUE_MAP;
    private final String value;

    private ROS2PrimitiveType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ROS2PrimitiveType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ROS2PrimitiveType> knownValues() {
        EnumSet<ROS2PrimitiveType> knownValues = EnumSet.allOf(ROS2PrimitiveType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ROS2PrimitiveType.class, ROS2PrimitiveType::toString);
    }
}

