/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListStateTemplatesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListStateTemplatesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateSummary;

public class ListStateTemplatesPublisher
implements SdkPublisher<ListStateTemplatesResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListStateTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStateTemplatesPublisher(IoTFleetWiseAsyncClient client, ListStateTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStateTemplatesPublisher(IoTFleetWiseAsyncClient client, ListStateTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStateTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStateTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StateTemplateSummary> summaries() {
        Function<ListStateTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStateTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStateTemplatesResponseFetcher
    implements AsyncPageFetcher<ListStateTemplatesResponse> {
        private ListStateTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListStateTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStateTemplatesResponse> nextPage(ListStateTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListStateTemplatesPublisher.this.client.listStateTemplates(ListStateTemplatesPublisher.this.firstRequest);
            }
            return ListStateTemplatesPublisher.this.client.listStateTemplates((ListStateTemplatesRequest)((Object)ListStateTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

