/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleSummary;

public class ListVehiclesPublisher
implements SdkPublisher<ListVehiclesResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListVehiclesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVehiclesPublisher(IoTFleetWiseAsyncClient client, ListVehiclesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVehiclesPublisher(IoTFleetWiseAsyncClient client, ListVehiclesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVehiclesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVehiclesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VehicleSummary> vehicleSummaries() {
        Function<ListVehiclesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vehicleSummaries() != null) {
                return response.vehicleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVehiclesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVehiclesResponseFetcher
    implements AsyncPageFetcher<ListVehiclesResponse> {
        private ListVehiclesResponseFetcher() {
        }

        public boolean hasNextPage(ListVehiclesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVehiclesResponse> nextPage(ListVehiclesResponse previousPage) {
            if (previousPage == null) {
                return ListVehiclesPublisher.this.client.listVehicles(ListVehiclesPublisher.this.firstRequest);
            }
            return ListVehiclesPublisher.this.client.listVehicles((ListVehiclesRequest)((Object)ListVehiclesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

