/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompatibleKafkaVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompatibleKafkaVersion> {
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceVersion").getter(CompatibleKafkaVersion.getter(CompatibleKafkaVersion::sourceVersion)).setter(CompatibleKafkaVersion.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<List<String>> TARGET_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetVersions").getter(CompatibleKafkaVersion.getter(CompatibleKafkaVersion::targetVersions)).setter(CompatibleKafkaVersion.setter(Builder::targetVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VERSION_FIELD, TARGET_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompatibleKafkaVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceVersion;
    private final List<String> targetVersions;

    private CompatibleKafkaVersion(BuilderImpl builder) {
        this.sourceVersion = builder.sourceVersion;
        this.targetVersions = builder.targetVersions;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final boolean hasTargetVersions() {
        return this.targetVersions != null && !(this.targetVersions instanceof SdkAutoConstructList);
    }

    public final List<String> targetVersions() {
        return this.targetVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetVersions() ? this.targetVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompatibleKafkaVersion)) {
            return false;
        }
        CompatibleKafkaVersion other = (CompatibleKafkaVersion)obj;
        return Objects.equals(this.sourceVersion(), other.sourceVersion()) && this.hasTargetVersions() == other.hasTargetVersions() && Objects.equals(this.targetVersions(), other.targetVersions());
    }

    public final String toString() {
        return ToString.builder((String)"CompatibleKafkaVersion").add("SourceVersion", (Object)this.sourceVersion()).add("TargetVersions", this.hasTargetVersions() ? this.targetVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "TargetVersions": {
                return Optional.ofNullable(clazz.cast(this.targetVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        map.put("targetVersions", TARGET_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompatibleKafkaVersion, T> g) {
        return obj -> g.apply((CompatibleKafkaVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceVersion;
        private List<String> targetVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompatibleKafkaVersion model) {
            this.sourceVersion(model.sourceVersion);
            this.targetVersions(model.targetVersions);
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final Collection<String> getTargetVersions() {
            if (this.targetVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetVersions;
        }

        public final void setTargetVersions(Collection<String> targetVersions) {
            this.targetVersions = ___listOf__stringCopier.copy(targetVersions);
        }

        @Override
        public final Builder targetVersions(Collection<String> targetVersions) {
            this.targetVersions = ___listOf__stringCopier.copy(targetVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetVersions(String ... targetVersions) {
            this.targetVersions(Arrays.asList(targetVersions));
            return this;
        }

        public CompatibleKafkaVersion build() {
            return new CompatibleKafkaVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompatibleKafkaVersion> {
        public Builder sourceVersion(String var1);

        public Builder targetVersions(Collection<String> var1);

        public Builder targetVersions(String ... var1);
    }
}

