/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ZookeeperNodeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ZookeeperNodeInfo> {
    private static final SdkField<String> ATTACHED_ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachedENIId").getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::attachedENIId)).setter(ZookeeperNodeInfo.setter(Builder::attachedENIId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedENIId").build()}).build();
    private static final SdkField<String> CLIENT_VPC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpcIpAddress").getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::clientVpcIpAddress)).setter(ZookeeperNodeInfo.setter(Builder::clientVpcIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientVpcIpAddress").build()}).build();
    private static final SdkField<List<String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::endpoints)).setter(ZookeeperNodeInfo.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> ZOOKEEPER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ZookeeperId").getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::zookeeperId)).setter(ZookeeperNodeInfo.setter(Builder::zookeeperId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperId").build()}).build();
    private static final SdkField<String> ZOOKEEPER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperVersion").getter(ZookeeperNodeInfo.getter(ZookeeperNodeInfo::zookeeperVersion)).setter(ZookeeperNodeInfo.setter(Builder::zookeeperVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_ENI_ID_FIELD, CLIENT_VPC_IP_ADDRESS_FIELD, ENDPOINTS_FIELD, ZOOKEEPER_ID_FIELD, ZOOKEEPER_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ZookeeperNodeInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attachedENIId;
    private final String clientVpcIpAddress;
    private final List<String> endpoints;
    private final Double zookeeperId;
    private final String zookeeperVersion;

    private ZookeeperNodeInfo(BuilderImpl builder) {
        this.attachedENIId = builder.attachedENIId;
        this.clientVpcIpAddress = builder.clientVpcIpAddress;
        this.endpoints = builder.endpoints;
        this.zookeeperId = builder.zookeeperId;
        this.zookeeperVersion = builder.zookeeperVersion;
    }

    public final String attachedENIId() {
        return this.attachedENIId;
    }

    public final String clientVpcIpAddress() {
        return this.clientVpcIpAddress;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<String> endpoints() {
        return this.endpoints;
    }

    public final Double zookeeperId() {
        return this.zookeeperId;
    }

    public final String zookeeperVersion() {
        return this.zookeeperVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedENIId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpcIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperId());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZookeeperNodeInfo)) {
            return false;
        }
        ZookeeperNodeInfo other = (ZookeeperNodeInfo)obj;
        return Objects.equals(this.attachedENIId(), other.attachedENIId()) && Objects.equals(this.clientVpcIpAddress(), other.clientVpcIpAddress()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.zookeeperId(), other.zookeeperId()) && Objects.equals(this.zookeeperVersion(), other.zookeeperVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ZookeeperNodeInfo").add("AttachedENIId", (Object)this.attachedENIId()).add("ClientVpcIpAddress", (Object)this.clientVpcIpAddress()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("ZookeeperId", (Object)this.zookeeperId()).add("ZookeeperVersion", (Object)this.zookeeperVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedENIId": {
                return Optional.ofNullable(clazz.cast(this.attachedENIId()));
            }
            case "ClientVpcIpAddress": {
                return Optional.ofNullable(clazz.cast(this.clientVpcIpAddress()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "ZookeeperId": {
                return Optional.ofNullable(clazz.cast(this.zookeeperId()));
            }
            case "ZookeeperVersion": {
                return Optional.ofNullable(clazz.cast(this.zookeeperVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attachedENIId", ATTACHED_ENI_ID_FIELD);
        map.put("clientVpcIpAddress", CLIENT_VPC_IP_ADDRESS_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        map.put("zookeeperId", ZOOKEEPER_ID_FIELD);
        map.put("zookeeperVersion", ZOOKEEPER_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZookeeperNodeInfo, T> g) {
        return obj -> g.apply((ZookeeperNodeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachedENIId;
        private String clientVpcIpAddress;
        private List<String> endpoints = DefaultSdkAutoConstructList.getInstance();
        private Double zookeeperId;
        private String zookeeperVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ZookeeperNodeInfo model) {
            this.attachedENIId(model.attachedENIId);
            this.clientVpcIpAddress(model.clientVpcIpAddress);
            this.endpoints(model.endpoints);
            this.zookeeperId(model.zookeeperId);
            this.zookeeperVersion(model.zookeeperVersion);
        }

        public final String getAttachedENIId() {
            return this.attachedENIId;
        }

        public final void setAttachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
        }

        @Override
        public final Builder attachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
            return this;
        }

        public final String getClientVpcIpAddress() {
            return this.clientVpcIpAddress;
        }

        public final void setClientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
        }

        @Override
        public final Builder clientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
            return this;
        }

        public final Collection<String> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpoints;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final Double getZookeeperId() {
            return this.zookeeperId;
        }

        public final void setZookeeperId(Double zookeeperId) {
            this.zookeeperId = zookeeperId;
        }

        @Override
        public final Builder zookeeperId(Double zookeeperId) {
            this.zookeeperId = zookeeperId;
            return this;
        }

        public final String getZookeeperVersion() {
            return this.zookeeperVersion;
        }

        public final void setZookeeperVersion(String zookeeperVersion) {
            this.zookeeperVersion = zookeeperVersion;
        }

        @Override
        public final Builder zookeeperVersion(String zookeeperVersion) {
            this.zookeeperVersion = zookeeperVersion;
            return this;
        }

        public ZookeeperNodeInfo build() {
            return new ZookeeperNodeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ZookeeperNodeInfo> {
        public Builder attachedENIId(String var1);

        public Builder clientVpcIpAddress(String var1);

        public Builder endpoints(Collection<String> var1);

        public Builder endpoints(String ... var1);

        public Builder zookeeperId(Double var1);

        public Builder zookeeperVersion(String var1);
    }
}

