/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.DescribeTopicPartitionsRequest;
import software.amazon.awssdk.services.kafka.model.DescribeTopicPartitionsResponse;
import software.amazon.awssdk.services.kafka.model.TopicPartitionInfo;

public class DescribeTopicPartitionsIterable
implements SdkIterable<DescribeTopicPartitionsResponse> {
    private final KafkaClient client;
    private final DescribeTopicPartitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTopicPartitionsIterable(KafkaClient client, DescribeTopicPartitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTopicPartitionsResponseFetcher();
    }

    public Iterator<DescribeTopicPartitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TopicPartitionInfo> partitions() {
        Function<DescribeTopicPartitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.partitions() != null) {
                return response.partitions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTopicPartitionsResponseFetcher
    implements SyncPageFetcher<DescribeTopicPartitionsResponse> {
        private DescribeTopicPartitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTopicPartitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTopicPartitionsResponse nextPage(DescribeTopicPartitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTopicPartitionsIterable.this.client.describeTopicPartitions(DescribeTopicPartitionsIterable.this.firstRequest);
            }
            return DescribeTopicPartitionsIterable.this.client.describeTopicPartitions((DescribeTopicPartitionsRequest)((Object)DescribeTopicPartitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

