/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.model;

import java.beans.Transient;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCell;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellListCopier;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellMapCopier;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesCellMapDefinition;
import software.amazon.awssdk.services.keyspacesstreams.model.KeyspacesUdtMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyspacesCellValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyspacesCellValue> {
    private static final SdkField<String> ASCIIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("asciiT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::asciiT)).setter(KeyspacesCellValue.setter(Builder::asciiT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asciiT").build()}).build();
    private static final SdkField<String> BIGINTT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bigintT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::bigintT)).setter(KeyspacesCellValue.setter(Builder::bigintT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bigintT").build()}).build();
    private static final SdkField<SdkBytes> BLOBT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("blobT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::blobT)).setter(KeyspacesCellValue.setter(Builder::blobT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobT").build()}).build();
    private static final SdkField<Boolean> BOOLT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("boolT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::boolT)).setter(KeyspacesCellValue.setter(Builder::boolT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("boolT").build()}).build();
    private static final SdkField<String> COUNTERT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("counterT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::counterT)).setter(KeyspacesCellValue.setter(Builder::counterT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("counterT").build()}).build();
    private static final SdkField<String> DATET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::dateT)).setter(KeyspacesCellValue.setter(Builder::dateT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateT").build()}).build();
    private static final SdkField<String> DECIMALT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decimalT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::decimalT)).setter(KeyspacesCellValue.setter(Builder::decimalT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decimalT").build()}).build();
    private static final SdkField<String> DOUBLET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("doubleT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::doubleT)).setter(KeyspacesCellValue.setter(Builder::doubleT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleT").build()}).build();
    private static final SdkField<String> FLOATT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("floatT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::floatT)).setter(KeyspacesCellValue.setter(Builder::floatT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("floatT").build()}).build();
    private static final SdkField<String> INETT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inetT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::inetT)).setter(KeyspacesCellValue.setter(Builder::inetT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inetT").build()}).build();
    private static final SdkField<String> INTT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::intT)).setter(KeyspacesCellValue.setter(Builder::intT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intT").build()}).build();
    private static final SdkField<List<KeyspacesCell>> LISTT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::listT)).setter(KeyspacesCellValue.setter(Builder::listT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listT").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KeyspacesCellMapDefinition>> MAPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mapT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::mapT)).setter(KeyspacesCellValue.setter(Builder::mapT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapT").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCellMapDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KeyspacesCell>> SETT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("setT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::setT)).setter(KeyspacesCellValue.setter(Builder::setT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setT").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SMALLINTT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("smallintT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::smallintT)).setter(KeyspacesCellValue.setter(Builder::smallintT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smallintT").build()}).build();
    private static final SdkField<String> TEXTT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("textT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::textT)).setter(KeyspacesCellValue.setter(Builder::textT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textT").build()}).build();
    private static final SdkField<String> TIMET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::timeT)).setter(KeyspacesCellValue.setter(Builder::timeT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeT").build()}).build();
    private static final SdkField<String> TIMESTAMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timestampT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::timestampT)).setter(KeyspacesCellValue.setter(Builder::timestampT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampT").build()}).build();
    private static final SdkField<String> TIMEUUIDT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeuuidT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::timeuuidT)).setter(KeyspacesCellValue.setter(Builder::timeuuidT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeuuidT").build()}).build();
    private static final SdkField<String> TINYINTT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tinyintT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::tinyintT)).setter(KeyspacesCellValue.setter(Builder::tinyintT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tinyintT").build()}).build();
    private static final SdkField<List<KeyspacesCell>> TUPLET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tupleT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::tupleT)).setter(KeyspacesCellValue.setter(Builder::tupleT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tupleT").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UUIDT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uuidT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::uuidT)).setter(KeyspacesCellValue.setter(Builder::uuidT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuidT").build()}).build();
    private static final SdkField<String> VARCHART_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("varcharT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::varcharT)).setter(KeyspacesCellValue.setter(Builder::varcharT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("varcharT").build()}).build();
    private static final SdkField<String> VARINTT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("varintT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::varintT)).setter(KeyspacesCellValue.setter(Builder::varintT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("varintT").build()}).build();
    private static final SdkField<Map<String, KeyspacesCell>> UDTT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("udtT").getter(KeyspacesCellValue.getter(KeyspacesCellValue::udtT)).setter(KeyspacesCellValue.setter(Builder::udtT)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udtT").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyspacesCell::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASCIIT_FIELD, BIGINTT_FIELD, BLOBT_FIELD, BOOLT_FIELD, COUNTERT_FIELD, DATET_FIELD, DECIMALT_FIELD, DOUBLET_FIELD, FLOATT_FIELD, INETT_FIELD, INTT_FIELD, LISTT_FIELD, MAPT_FIELD, SETT_FIELD, SMALLINTT_FIELD, TEXTT_FIELD, TIMET_FIELD, TIMESTAMPT_FIELD, TIMEUUIDT_FIELD, TINYINTT_FIELD, TUPLET_FIELD, UUIDT_FIELD, VARCHART_FIELD, VARINTT_FIELD, UDTT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeyspacesCellValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String asciiT;
    private final String bigintT;
    private final SdkBytes blobT;
    private final Boolean boolT;
    private final String counterT;
    private final String dateT;
    private final String decimalT;
    private final String doubleT;
    private final String floatT;
    private final String inetT;
    private final String intT;
    private final List<KeyspacesCell> listT;
    private final List<KeyspacesCellMapDefinition> mapT;
    private final List<KeyspacesCell> setT;
    private final String smallintT;
    private final String textT;
    private final String timeT;
    private final String timestampT;
    private final String timeuuidT;
    private final String tinyintT;
    private final List<KeyspacesCell> tupleT;
    private final String uuidT;
    private final String varcharT;
    private final String varintT;
    private final Map<String, KeyspacesCell> udtT;
    private final Type type;

    private KeyspacesCellValue(BuilderImpl builder) {
        this.asciiT = builder.asciiT;
        this.bigintT = builder.bigintT;
        this.blobT = builder.blobT;
        this.boolT = builder.boolT;
        this.counterT = builder.counterT;
        this.dateT = builder.dateT;
        this.decimalT = builder.decimalT;
        this.doubleT = builder.doubleT;
        this.floatT = builder.floatT;
        this.inetT = builder.inetT;
        this.intT = builder.intT;
        this.listT = builder.listT;
        this.mapT = builder.mapT;
        this.setT = builder.setT;
        this.smallintT = builder.smallintT;
        this.textT = builder.textT;
        this.timeT = builder.timeT;
        this.timestampT = builder.timestampT;
        this.timeuuidT = builder.timeuuidT;
        this.tinyintT = builder.tinyintT;
        this.tupleT = builder.tupleT;
        this.uuidT = builder.uuidT;
        this.varcharT = builder.varcharT;
        this.varintT = builder.varintT;
        this.udtT = builder.udtT;
        this.type = builder.type;
    }

    public final String asciiT() {
        return this.asciiT;
    }

    public final String bigintT() {
        return this.bigintT;
    }

    public final SdkBytes blobT() {
        return this.blobT;
    }

    public final Boolean boolT() {
        return this.boolT;
    }

    public final String counterT() {
        return this.counterT;
    }

    public final String dateT() {
        return this.dateT;
    }

    public final String decimalT() {
        return this.decimalT;
    }

    public final String doubleT() {
        return this.doubleT;
    }

    public final String floatT() {
        return this.floatT;
    }

    public final String inetT() {
        return this.inetT;
    }

    public final String intT() {
        return this.intT;
    }

    public final boolean hasListT() {
        return this.listT != null && !(this.listT instanceof SdkAutoConstructList);
    }

    public final List<KeyspacesCell> listT() {
        return this.listT;
    }

    public final boolean hasMapT() {
        return this.mapT != null && !(this.mapT instanceof SdkAutoConstructList);
    }

    public final List<KeyspacesCellMapDefinition> mapT() {
        return this.mapT;
    }

    public final boolean hasSetT() {
        return this.setT != null && !(this.setT instanceof SdkAutoConstructList);
    }

    public final List<KeyspacesCell> setT() {
        return this.setT;
    }

    public final String smallintT() {
        return this.smallintT;
    }

    public final String textT() {
        return this.textT;
    }

    public final String timeT() {
        return this.timeT;
    }

    public final String timestampT() {
        return this.timestampT;
    }

    public final String timeuuidT() {
        return this.timeuuidT;
    }

    public final String tinyintT() {
        return this.tinyintT;
    }

    public final boolean hasTupleT() {
        return this.tupleT != null && !(this.tupleT instanceof SdkAutoConstructList);
    }

    public final List<KeyspacesCell> tupleT() {
        return this.tupleT;
    }

    public final String uuidT() {
        return this.uuidT;
    }

    public final String varcharT() {
        return this.varcharT;
    }

    public final String varintT() {
        return this.varintT;
    }

    public final boolean hasUdtT() {
        return this.udtT != null && !(this.udtT instanceof SdkAutoConstructMap);
    }

    public final Map<String, KeyspacesCell> udtT() {
        return this.udtT;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.asciiT());
        hashCode = 31 * hashCode + Objects.hashCode(this.bigintT());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobT());
        hashCode = 31 * hashCode + Objects.hashCode(this.boolT());
        hashCode = 31 * hashCode + Objects.hashCode(this.counterT());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateT());
        hashCode = 31 * hashCode + Objects.hashCode(this.decimalT());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleT());
        hashCode = 31 * hashCode + Objects.hashCode(this.floatT());
        hashCode = 31 * hashCode + Objects.hashCode(this.inetT());
        hashCode = 31 * hashCode + Objects.hashCode(this.intT());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListT() ? this.listT() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapT() ? this.mapT() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSetT() ? this.setT() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.smallintT());
        hashCode = 31 * hashCode + Objects.hashCode(this.textT());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeT());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampT());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeuuidT());
        hashCode = 31 * hashCode + Objects.hashCode(this.tinyintT());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTupleT() ? this.tupleT() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uuidT());
        hashCode = 31 * hashCode + Objects.hashCode(this.varcharT());
        hashCode = 31 * hashCode + Objects.hashCode(this.varintT());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUdtT() ? this.udtT() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyspacesCellValue)) {
            return false;
        }
        KeyspacesCellValue other = (KeyspacesCellValue)obj;
        return Objects.equals(this.asciiT(), other.asciiT()) && Objects.equals(this.bigintT(), other.bigintT()) && Objects.equals(this.blobT(), other.blobT()) && Objects.equals(this.boolT(), other.boolT()) && Objects.equals(this.counterT(), other.counterT()) && Objects.equals(this.dateT(), other.dateT()) && Objects.equals(this.decimalT(), other.decimalT()) && Objects.equals(this.doubleT(), other.doubleT()) && Objects.equals(this.floatT(), other.floatT()) && Objects.equals(this.inetT(), other.inetT()) && Objects.equals(this.intT(), other.intT()) && this.hasListT() == other.hasListT() && Objects.equals(this.listT(), other.listT()) && this.hasMapT() == other.hasMapT() && Objects.equals(this.mapT(), other.mapT()) && this.hasSetT() == other.hasSetT() && Objects.equals(this.setT(), other.setT()) && Objects.equals(this.smallintT(), other.smallintT()) && Objects.equals(this.textT(), other.textT()) && Objects.equals(this.timeT(), other.timeT()) && Objects.equals(this.timestampT(), other.timestampT()) && Objects.equals(this.timeuuidT(), other.timeuuidT()) && Objects.equals(this.tinyintT(), other.tinyintT()) && this.hasTupleT() == other.hasTupleT() && Objects.equals(this.tupleT(), other.tupleT()) && Objects.equals(this.uuidT(), other.uuidT()) && Objects.equals(this.varcharT(), other.varcharT()) && Objects.equals(this.varintT(), other.varintT()) && this.hasUdtT() == other.hasUdtT() && Objects.equals(this.udtT(), other.udtT());
    }

    public final String toString() {
        return ToString.builder((String)"KeyspacesCellValue").add("AsciiT", (Object)this.asciiT()).add("BigintT", (Object)this.bigintT()).add("BlobT", (Object)this.blobT()).add("BoolT", (Object)this.boolT()).add("CounterT", (Object)this.counterT()).add("DateT", (Object)this.dateT()).add("DecimalT", (Object)this.decimalT()).add("DoubleT", (Object)this.doubleT()).add("FloatT", (Object)this.floatT()).add("InetT", (Object)this.inetT()).add("IntT", (Object)this.intT()).add("ListT", this.hasListT() ? this.listT() : null).add("MapT", this.hasMapT() ? this.mapT() : null).add("SetT", this.hasSetT() ? this.setT() : null).add("SmallintT", (Object)this.smallintT()).add("TextT", (Object)this.textT()).add("TimeT", (Object)this.timeT()).add("TimestampT", (Object)this.timestampT()).add("TimeuuidT", (Object)this.timeuuidT()).add("TinyintT", (Object)this.tinyintT()).add("TupleT", this.hasTupleT() ? this.tupleT() : null).add("UuidT", (Object)this.uuidT()).add("VarcharT", (Object)this.varcharT()).add("VarintT", (Object)this.varintT()).add("UdtT", this.hasUdtT() ? this.udtT() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "asciiT": {
                return Optional.ofNullable(clazz.cast(this.asciiT()));
            }
            case "bigintT": {
                return Optional.ofNullable(clazz.cast(this.bigintT()));
            }
            case "blobT": {
                return Optional.ofNullable(clazz.cast(this.blobT()));
            }
            case "boolT": {
                return Optional.ofNullable(clazz.cast(this.boolT()));
            }
            case "counterT": {
                return Optional.ofNullable(clazz.cast(this.counterT()));
            }
            case "dateT": {
                return Optional.ofNullable(clazz.cast(this.dateT()));
            }
            case "decimalT": {
                return Optional.ofNullable(clazz.cast(this.decimalT()));
            }
            case "doubleT": {
                return Optional.ofNullable(clazz.cast(this.doubleT()));
            }
            case "floatT": {
                return Optional.ofNullable(clazz.cast(this.floatT()));
            }
            case "inetT": {
                return Optional.ofNullable(clazz.cast(this.inetT()));
            }
            case "intT": {
                return Optional.ofNullable(clazz.cast(this.intT()));
            }
            case "listT": {
                return Optional.ofNullable(clazz.cast(this.listT()));
            }
            case "mapT": {
                return Optional.ofNullable(clazz.cast(this.mapT()));
            }
            case "setT": {
                return Optional.ofNullable(clazz.cast(this.setT()));
            }
            case "smallintT": {
                return Optional.ofNullable(clazz.cast(this.smallintT()));
            }
            case "textT": {
                return Optional.ofNullable(clazz.cast(this.textT()));
            }
            case "timeT": {
                return Optional.ofNullable(clazz.cast(this.timeT()));
            }
            case "timestampT": {
                return Optional.ofNullable(clazz.cast(this.timestampT()));
            }
            case "timeuuidT": {
                return Optional.ofNullable(clazz.cast(this.timeuuidT()));
            }
            case "tinyintT": {
                return Optional.ofNullable(clazz.cast(this.tinyintT()));
            }
            case "tupleT": {
                return Optional.ofNullable(clazz.cast(this.tupleT()));
            }
            case "uuidT": {
                return Optional.ofNullable(clazz.cast(this.uuidT()));
            }
            case "varcharT": {
                return Optional.ofNullable(clazz.cast(this.varcharT()));
            }
            case "varintT": {
                return Optional.ofNullable(clazz.cast(this.varintT()));
            }
            case "udtT": {
                return Optional.ofNullable(clazz.cast(this.udtT()));
            }
        }
        return Optional.empty();
    }

    public static KeyspacesCellValue fromAsciiT(String asciiT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().asciiT(asciiT).build();
    }

    public static KeyspacesCellValue fromBigintT(String bigintT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().bigintT(bigintT).build();
    }

    public static KeyspacesCellValue fromBlobT(SdkBytes blobT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().blobT(blobT).build();
    }

    public static KeyspacesCellValue fromBoolT(Boolean boolT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().boolT(boolT).build();
    }

    public static KeyspacesCellValue fromCounterT(String counterT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().counterT(counterT).build();
    }

    public static KeyspacesCellValue fromDateT(String dateT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().dateT(dateT).build();
    }

    public static KeyspacesCellValue fromDecimalT(String decimalT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().decimalT(decimalT).build();
    }

    public static KeyspacesCellValue fromDoubleT(String doubleT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().doubleT(doubleT).build();
    }

    public static KeyspacesCellValue fromFloatT(String floatT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().floatT(floatT).build();
    }

    public static KeyspacesCellValue fromInetT(String inetT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().inetT(inetT).build();
    }

    public static KeyspacesCellValue fromIntT(String intT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().intT(intT).build();
    }

    public static KeyspacesCellValue fromListT(List<KeyspacesCell> listT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().listT(listT).build();
    }

    public static KeyspacesCellValue fromMapT(List<KeyspacesCellMapDefinition> mapT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().mapT(mapT).build();
    }

    public static KeyspacesCellValue fromSetT(List<KeyspacesCell> setT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().setT(setT).build();
    }

    public static KeyspacesCellValue fromSmallintT(String smallintT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().smallintT(smallintT).build();
    }

    public static KeyspacesCellValue fromTextT(String textT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().textT(textT).build();
    }

    public static KeyspacesCellValue fromTimeT(String timeT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().timeT(timeT).build();
    }

    public static KeyspacesCellValue fromTimestampT(String timestampT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().timestampT(timestampT).build();
    }

    public static KeyspacesCellValue fromTimeuuidT(String timeuuidT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().timeuuidT(timeuuidT).build();
    }

    public static KeyspacesCellValue fromTinyintT(String tinyintT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().tinyintT(tinyintT).build();
    }

    public static KeyspacesCellValue fromTupleT(List<KeyspacesCell> tupleT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().tupleT(tupleT).build();
    }

    public static KeyspacesCellValue fromUuidT(String uuidT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().uuidT(uuidT).build();
    }

    public static KeyspacesCellValue fromVarcharT(String varcharT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().varcharT(varcharT).build();
    }

    public static KeyspacesCellValue fromVarintT(String varintT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().varintT(varintT).build();
    }

    public static KeyspacesCellValue fromUdtT(Map<String, KeyspacesCell> udtT) {
        return (KeyspacesCellValue)KeyspacesCellValue.builder().udtT(udtT).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("asciiT", ASCIIT_FIELD);
        map.put("bigintT", BIGINTT_FIELD);
        map.put("blobT", BLOBT_FIELD);
        map.put("boolT", BOOLT_FIELD);
        map.put("counterT", COUNTERT_FIELD);
        map.put("dateT", DATET_FIELD);
        map.put("decimalT", DECIMALT_FIELD);
        map.put("doubleT", DOUBLET_FIELD);
        map.put("floatT", FLOATT_FIELD);
        map.put("inetT", INETT_FIELD);
        map.put("intT", INTT_FIELD);
        map.put("listT", LISTT_FIELD);
        map.put("mapT", MAPT_FIELD);
        map.put("setT", SETT_FIELD);
        map.put("smallintT", SMALLINTT_FIELD);
        map.put("textT", TEXTT_FIELD);
        map.put("timeT", TIMET_FIELD);
        map.put("timestampT", TIMESTAMPT_FIELD);
        map.put("timeuuidT", TIMEUUIDT_FIELD);
        map.put("tinyintT", TINYINTT_FIELD);
        map.put("tupleT", TUPLET_FIELD);
        map.put("uuidT", UUIDT_FIELD);
        map.put("varcharT", VARCHART_FIELD);
        map.put("varintT", VARINTT_FIELD);
        map.put("udtT", UDTT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyspacesCellValue, T> g) {
        return obj -> g.apply((KeyspacesCellValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ASCIIT,
        BIGINTT,
        BLOBT,
        BOOLT,
        COUNTERT,
        DATET,
        DECIMALT,
        DOUBLET,
        FLOATT,
        INETT,
        INTT,
        LISTT,
        MAPT,
        SETT,
        SMALLINTT,
        TEXTT,
        TIMET,
        TIMESTAMPT,
        TIMEUUIDT,
        TINYINTT,
        TUPLET,
        UUIDT,
        VARCHART,
        VARINTT,
        UDTT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String asciiT;
        private String bigintT;
        private SdkBytes blobT;
        private Boolean boolT;
        private String counterT;
        private String dateT;
        private String decimalT;
        private String doubleT;
        private String floatT;
        private String inetT;
        private String intT;
        private List<KeyspacesCell> listT = DefaultSdkAutoConstructList.getInstance();
        private List<KeyspacesCellMapDefinition> mapT = DefaultSdkAutoConstructList.getInstance();
        private List<KeyspacesCell> setT = DefaultSdkAutoConstructList.getInstance();
        private String smallintT;
        private String textT;
        private String timeT;
        private String timestampT;
        private String timeuuidT;
        private String tinyintT;
        private List<KeyspacesCell> tupleT = DefaultSdkAutoConstructList.getInstance();
        private String uuidT;
        private String varcharT;
        private String varintT;
        private Map<String, KeyspacesCell> udtT = DefaultSdkAutoConstructMap.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KeyspacesCellValue model) {
            this.asciiT(model.asciiT);
            this.bigintT(model.bigintT);
            this.blobT(model.blobT);
            this.boolT(model.boolT);
            this.counterT(model.counterT);
            this.dateT(model.dateT);
            this.decimalT(model.decimalT);
            this.doubleT(model.doubleT);
            this.floatT(model.floatT);
            this.inetT(model.inetT);
            this.intT(model.intT);
            this.listT(model.listT);
            this.mapT(model.mapT);
            this.setT(model.setT);
            this.smallintT(model.smallintT);
            this.textT(model.textT);
            this.timeT(model.timeT);
            this.timestampT(model.timestampT);
            this.timeuuidT(model.timeuuidT);
            this.tinyintT(model.tinyintT);
            this.tupleT(model.tupleT);
            this.uuidT(model.uuidT);
            this.varcharT(model.varcharT);
            this.varintT(model.varintT);
            this.udtT(model.udtT);
        }

        public final String getAsciiT() {
            return this.asciiT;
        }

        public final void setAsciiT(String asciiT) {
            String oldValue = this.asciiT;
            this.asciiT = asciiT;
            this.handleUnionValueChange(Type.ASCIIT, oldValue, this.asciiT);
        }

        @Override
        public final Builder asciiT(String asciiT) {
            String oldValue = this.asciiT;
            this.asciiT = asciiT;
            this.handleUnionValueChange(Type.ASCIIT, oldValue, this.asciiT);
            return this;
        }

        public final String getBigintT() {
            return this.bigintT;
        }

        public final void setBigintT(String bigintT) {
            String oldValue = this.bigintT;
            this.bigintT = bigintT;
            this.handleUnionValueChange(Type.BIGINTT, oldValue, this.bigintT);
        }

        @Override
        public final Builder bigintT(String bigintT) {
            String oldValue = this.bigintT;
            this.bigintT = bigintT;
            this.handleUnionValueChange(Type.BIGINTT, oldValue, this.bigintT);
            return this;
        }

        public final ByteBuffer getBlobT() {
            return this.blobT == null ? null : this.blobT.asByteBuffer();
        }

        public final void setBlobT(ByteBuffer blobT) {
            this.blobT(blobT == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blobT));
        }

        @Override
        public final Builder blobT(SdkBytes blobT) {
            SdkBytes oldValue = this.blobT;
            this.blobT = blobT;
            this.handleUnionValueChange(Type.BLOBT, oldValue, this.blobT);
            return this;
        }

        public final Boolean getBoolT() {
            return this.boolT;
        }

        public final void setBoolT(Boolean boolT) {
            Boolean oldValue = this.boolT;
            this.boolT = boolT;
            this.handleUnionValueChange(Type.BOOLT, oldValue, this.boolT);
        }

        @Override
        public final Builder boolT(Boolean boolT) {
            Boolean oldValue = this.boolT;
            this.boolT = boolT;
            this.handleUnionValueChange(Type.BOOLT, oldValue, this.boolT);
            return this;
        }

        public final String getCounterT() {
            return this.counterT;
        }

        public final void setCounterT(String counterT) {
            String oldValue = this.counterT;
            this.counterT = counterT;
            this.handleUnionValueChange(Type.COUNTERT, oldValue, this.counterT);
        }

        @Override
        public final Builder counterT(String counterT) {
            String oldValue = this.counterT;
            this.counterT = counterT;
            this.handleUnionValueChange(Type.COUNTERT, oldValue, this.counterT);
            return this;
        }

        public final String getDateT() {
            return this.dateT;
        }

        public final void setDateT(String dateT) {
            String oldValue = this.dateT;
            this.dateT = dateT;
            this.handleUnionValueChange(Type.DATET, oldValue, this.dateT);
        }

        @Override
        public final Builder dateT(String dateT) {
            String oldValue = this.dateT;
            this.dateT = dateT;
            this.handleUnionValueChange(Type.DATET, oldValue, this.dateT);
            return this;
        }

        public final String getDecimalT() {
            return this.decimalT;
        }

        public final void setDecimalT(String decimalT) {
            String oldValue = this.decimalT;
            this.decimalT = decimalT;
            this.handleUnionValueChange(Type.DECIMALT, oldValue, this.decimalT);
        }

        @Override
        public final Builder decimalT(String decimalT) {
            String oldValue = this.decimalT;
            this.decimalT = decimalT;
            this.handleUnionValueChange(Type.DECIMALT, oldValue, this.decimalT);
            return this;
        }

        public final String getDoubleT() {
            return this.doubleT;
        }

        public final void setDoubleT(String doubleT) {
            String oldValue = this.doubleT;
            this.doubleT = doubleT;
            this.handleUnionValueChange(Type.DOUBLET, oldValue, this.doubleT);
        }

        @Override
        public final Builder doubleT(String doubleT) {
            String oldValue = this.doubleT;
            this.doubleT = doubleT;
            this.handleUnionValueChange(Type.DOUBLET, oldValue, this.doubleT);
            return this;
        }

        public final String getFloatT() {
            return this.floatT;
        }

        public final void setFloatT(String floatT) {
            String oldValue = this.floatT;
            this.floatT = floatT;
            this.handleUnionValueChange(Type.FLOATT, oldValue, this.floatT);
        }

        @Override
        public final Builder floatT(String floatT) {
            String oldValue = this.floatT;
            this.floatT = floatT;
            this.handleUnionValueChange(Type.FLOATT, oldValue, this.floatT);
            return this;
        }

        public final String getInetT() {
            return this.inetT;
        }

        public final void setInetT(String inetT) {
            String oldValue = this.inetT;
            this.inetT = inetT;
            this.handleUnionValueChange(Type.INETT, oldValue, this.inetT);
        }

        @Override
        public final Builder inetT(String inetT) {
            String oldValue = this.inetT;
            this.inetT = inetT;
            this.handleUnionValueChange(Type.INETT, oldValue, this.inetT);
            return this;
        }

        public final String getIntT() {
            return this.intT;
        }

        public final void setIntT(String intT) {
            String oldValue = this.intT;
            this.intT = intT;
            this.handleUnionValueChange(Type.INTT, oldValue, this.intT);
        }

        @Override
        public final Builder intT(String intT) {
            String oldValue = this.intT;
            this.intT = intT;
            this.handleUnionValueChange(Type.INTT, oldValue, this.intT);
            return this;
        }

        public final List<KeyspacesCell.Builder> getListT() {
            List<KeyspacesCell.Builder> result = KeyspacesCellListCopier.copyToBuilder(this.listT);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListT(Collection<KeyspacesCell.BuilderImpl> listT) {
            List<KeyspacesCell> oldValue = this.listT;
            this.listT = KeyspacesCellListCopier.copyFromBuilder(listT);
            this.handleUnionValueChange(Type.LISTT, oldValue, this.listT);
        }

        @Override
        public final Builder listT(Collection<KeyspacesCell> listT) {
            List<KeyspacesCell> oldValue = this.listT;
            this.listT = KeyspacesCellListCopier.copy(listT);
            this.handleUnionValueChange(Type.LISTT, oldValue, this.listT);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listT(KeyspacesCell ... listT) {
            this.listT(Arrays.asList(listT));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listT(Consumer<KeyspacesCell.Builder> ... listT) {
            this.listT(Stream.of(listT).map(c -> (KeyspacesCell)((KeyspacesCell.Builder)KeyspacesCell.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KeyspacesCellMapDefinition.Builder> getMapT() {
            List<KeyspacesCellMapDefinition.Builder> result = KeyspacesCellMapCopier.copyToBuilder(this.mapT);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapT(Collection<KeyspacesCellMapDefinition.BuilderImpl> mapT) {
            List<KeyspacesCellMapDefinition> oldValue = this.mapT;
            this.mapT = KeyspacesCellMapCopier.copyFromBuilder(mapT);
            this.handleUnionValueChange(Type.MAPT, oldValue, this.mapT);
        }

        @Override
        public final Builder mapT(Collection<KeyspacesCellMapDefinition> mapT) {
            List<KeyspacesCellMapDefinition> oldValue = this.mapT;
            this.mapT = KeyspacesCellMapCopier.copy(mapT);
            this.handleUnionValueChange(Type.MAPT, oldValue, this.mapT);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapT(KeyspacesCellMapDefinition ... mapT) {
            this.mapT(Arrays.asList(mapT));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapT(Consumer<KeyspacesCellMapDefinition.Builder> ... mapT) {
            this.mapT(Stream.of(mapT).map(c -> (KeyspacesCellMapDefinition)((KeyspacesCellMapDefinition.Builder)KeyspacesCellMapDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KeyspacesCell.Builder> getSetT() {
            List<KeyspacesCell.Builder> result = KeyspacesCellListCopier.copyToBuilder(this.setT);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSetT(Collection<KeyspacesCell.BuilderImpl> setT) {
            List<KeyspacesCell> oldValue = this.setT;
            this.setT = KeyspacesCellListCopier.copyFromBuilder(setT);
            this.handleUnionValueChange(Type.SETT, oldValue, this.setT);
        }

        @Override
        @Transient
        public final Builder setT(Collection<KeyspacesCell> setT) {
            List<KeyspacesCell> oldValue = this.setT;
            this.setT = KeyspacesCellListCopier.copy(setT);
            this.handleUnionValueChange(Type.SETT, oldValue, this.setT);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setT(KeyspacesCell ... setT) {
            this.setT(Arrays.asList(setT));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder setT(Consumer<KeyspacesCell.Builder> ... setT) {
            this.setT(Stream.of(setT).map(c -> (KeyspacesCell)((KeyspacesCell.Builder)KeyspacesCell.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSmallintT() {
            return this.smallintT;
        }

        public final void setSmallintT(String smallintT) {
            String oldValue = this.smallintT;
            this.smallintT = smallintT;
            this.handleUnionValueChange(Type.SMALLINTT, oldValue, this.smallintT);
        }

        @Override
        public final Builder smallintT(String smallintT) {
            String oldValue = this.smallintT;
            this.smallintT = smallintT;
            this.handleUnionValueChange(Type.SMALLINTT, oldValue, this.smallintT);
            return this;
        }

        public final String getTextT() {
            return this.textT;
        }

        public final void setTextT(String textT) {
            String oldValue = this.textT;
            this.textT = textT;
            this.handleUnionValueChange(Type.TEXTT, oldValue, this.textT);
        }

        @Override
        public final Builder textT(String textT) {
            String oldValue = this.textT;
            this.textT = textT;
            this.handleUnionValueChange(Type.TEXTT, oldValue, this.textT);
            return this;
        }

        public final String getTimeT() {
            return this.timeT;
        }

        public final void setTimeT(String timeT) {
            String oldValue = this.timeT;
            this.timeT = timeT;
            this.handleUnionValueChange(Type.TIMET, oldValue, this.timeT);
        }

        @Override
        public final Builder timeT(String timeT) {
            String oldValue = this.timeT;
            this.timeT = timeT;
            this.handleUnionValueChange(Type.TIMET, oldValue, this.timeT);
            return this;
        }

        public final String getTimestampT() {
            return this.timestampT;
        }

        public final void setTimestampT(String timestampT) {
            String oldValue = this.timestampT;
            this.timestampT = timestampT;
            this.handleUnionValueChange(Type.TIMESTAMPT, oldValue, this.timestampT);
        }

        @Override
        public final Builder timestampT(String timestampT) {
            String oldValue = this.timestampT;
            this.timestampT = timestampT;
            this.handleUnionValueChange(Type.TIMESTAMPT, oldValue, this.timestampT);
            return this;
        }

        public final String getTimeuuidT() {
            return this.timeuuidT;
        }

        public final void setTimeuuidT(String timeuuidT) {
            String oldValue = this.timeuuidT;
            this.timeuuidT = timeuuidT;
            this.handleUnionValueChange(Type.TIMEUUIDT, oldValue, this.timeuuidT);
        }

        @Override
        public final Builder timeuuidT(String timeuuidT) {
            String oldValue = this.timeuuidT;
            this.timeuuidT = timeuuidT;
            this.handleUnionValueChange(Type.TIMEUUIDT, oldValue, this.timeuuidT);
            return this;
        }

        public final String getTinyintT() {
            return this.tinyintT;
        }

        public final void setTinyintT(String tinyintT) {
            String oldValue = this.tinyintT;
            this.tinyintT = tinyintT;
            this.handleUnionValueChange(Type.TINYINTT, oldValue, this.tinyintT);
        }

        @Override
        public final Builder tinyintT(String tinyintT) {
            String oldValue = this.tinyintT;
            this.tinyintT = tinyintT;
            this.handleUnionValueChange(Type.TINYINTT, oldValue, this.tinyintT);
            return this;
        }

        public final List<KeyspacesCell.Builder> getTupleT() {
            List<KeyspacesCell.Builder> result = KeyspacesCellListCopier.copyToBuilder(this.tupleT);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTupleT(Collection<KeyspacesCell.BuilderImpl> tupleT) {
            List<KeyspacesCell> oldValue = this.tupleT;
            this.tupleT = KeyspacesCellListCopier.copyFromBuilder(tupleT);
            this.handleUnionValueChange(Type.TUPLET, oldValue, this.tupleT);
        }

        @Override
        public final Builder tupleT(Collection<KeyspacesCell> tupleT) {
            List<KeyspacesCell> oldValue = this.tupleT;
            this.tupleT = KeyspacesCellListCopier.copy(tupleT);
            this.handleUnionValueChange(Type.TUPLET, oldValue, this.tupleT);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tupleT(KeyspacesCell ... tupleT) {
            this.tupleT(Arrays.asList(tupleT));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tupleT(Consumer<KeyspacesCell.Builder> ... tupleT) {
            this.tupleT(Stream.of(tupleT).map(c -> (KeyspacesCell)((KeyspacesCell.Builder)KeyspacesCell.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUuidT() {
            return this.uuidT;
        }

        public final void setUuidT(String uuidT) {
            String oldValue = this.uuidT;
            this.uuidT = uuidT;
            this.handleUnionValueChange(Type.UUIDT, oldValue, this.uuidT);
        }

        @Override
        public final Builder uuidT(String uuidT) {
            String oldValue = this.uuidT;
            this.uuidT = uuidT;
            this.handleUnionValueChange(Type.UUIDT, oldValue, this.uuidT);
            return this;
        }

        public final String getVarcharT() {
            return this.varcharT;
        }

        public final void setVarcharT(String varcharT) {
            String oldValue = this.varcharT;
            this.varcharT = varcharT;
            this.handleUnionValueChange(Type.VARCHART, oldValue, this.varcharT);
        }

        @Override
        public final Builder varcharT(String varcharT) {
            String oldValue = this.varcharT;
            this.varcharT = varcharT;
            this.handleUnionValueChange(Type.VARCHART, oldValue, this.varcharT);
            return this;
        }

        public final String getVarintT() {
            return this.varintT;
        }

        public final void setVarintT(String varintT) {
            String oldValue = this.varintT;
            this.varintT = varintT;
            this.handleUnionValueChange(Type.VARINTT, oldValue, this.varintT);
        }

        @Override
        public final Builder varintT(String varintT) {
            String oldValue = this.varintT;
            this.varintT = varintT;
            this.handleUnionValueChange(Type.VARINTT, oldValue, this.varintT);
            return this;
        }

        public final Map<String, KeyspacesCell.Builder> getUdtT() {
            Map<String, KeyspacesCell.Builder> result = KeyspacesUdtMapCopier.copyToBuilder(this.udtT);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setUdtT(Map<String, KeyspacesCell.BuilderImpl> udtT) {
            Map<String, KeyspacesCell> oldValue = this.udtT;
            this.udtT = KeyspacesUdtMapCopier.copyFromBuilder(udtT);
            this.handleUnionValueChange(Type.UDTT, oldValue, this.udtT);
        }

        @Override
        public final Builder udtT(Map<String, KeyspacesCell> udtT) {
            Map<String, KeyspacesCell> oldValue = this.udtT;
            this.udtT = KeyspacesUdtMapCopier.copy(udtT);
            this.handleUnionValueChange(Type.UDTT, oldValue, this.udtT);
            return this;
        }

        public KeyspacesCellValue build() {
            return new KeyspacesCellValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyspacesCellValue> {
        public Builder asciiT(String var1);

        public Builder bigintT(String var1);

        public Builder blobT(SdkBytes var1);

        public Builder boolT(Boolean var1);

        public Builder counterT(String var1);

        public Builder dateT(String var1);

        public Builder decimalT(String var1);

        public Builder doubleT(String var1);

        public Builder floatT(String var1);

        public Builder inetT(String var1);

        public Builder intT(String var1);

        public Builder listT(Collection<KeyspacesCell> var1);

        public Builder listT(KeyspacesCell ... var1);

        public Builder listT(Consumer<KeyspacesCell.Builder> ... var1);

        public Builder mapT(Collection<KeyspacesCellMapDefinition> var1);

        public Builder mapT(KeyspacesCellMapDefinition ... var1);

        public Builder mapT(Consumer<KeyspacesCellMapDefinition.Builder> ... var1);

        public Builder setT(Collection<KeyspacesCell> var1);

        public Builder setT(KeyspacesCell ... var1);

        public Builder setT(Consumer<KeyspacesCell.Builder> ... var1);

        public Builder smallintT(String var1);

        public Builder textT(String var1);

        public Builder timeT(String var1);

        public Builder timestampT(String var1);

        public Builder timeuuidT(String var1);

        public Builder tinyintT(String var1);

        public Builder tupleT(Collection<KeyspacesCell> var1);

        public Builder tupleT(KeyspacesCell ... var1);

        public Builder tupleT(Consumer<KeyspacesCell.Builder> ... var1);

        public Builder uuidT(String var1);

        public Builder varcharT(String var1);

        public Builder varintT(String var1);

        public Builder udtT(Map<String, KeyspacesCell> var1);
    }
}

