/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteApplicationCloudWatchLoggingOptionRequest
extends KinesisAnalyticsRequest
implements ToCopyableBuilder<Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(DeleteApplicationCloudWatchLoggingOptionRequest.getter(DeleteApplicationCloudWatchLoggingOptionRequest::applicationName)).setter(DeleteApplicationCloudWatchLoggingOptionRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentApplicationVersionId").getter(DeleteApplicationCloudWatchLoggingOptionRequest.getter(DeleteApplicationCloudWatchLoggingOptionRequest::currentApplicationVersionId)).setter(DeleteApplicationCloudWatchLoggingOptionRequest.setter(Builder::currentApplicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGGING_OPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLoggingOptionId").getter(DeleteApplicationCloudWatchLoggingOptionRequest.getter(DeleteApplicationCloudWatchLoggingOptionRequest::cloudWatchLoggingOptionId)).setter(DeleteApplicationCloudWatchLoggingOptionRequest.setter(Builder::cloudWatchLoggingOptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, CURRENT_APPLICATION_VERSION_ID_FIELD, CLOUD_WATCH_LOGGING_OPTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteApplicationCloudWatchLoggingOptionRequest.memberNameToFieldInitializer();
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final String cloudWatchLoggingOptionId;

    private DeleteApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public final String cloudWatchLoggingOptionId() {
        return this.cloudWatchLoggingOptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        DeleteApplicationCloudWatchLoggingOptionRequest other = (DeleteApplicationCloudWatchLoggingOptionRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.cloudWatchLoggingOptionId(), other.cloudWatchLoggingOptionId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteApplicationCloudWatchLoggingOptionRequest").add("ApplicationName", (Object)this.applicationName()).add("CurrentApplicationVersionId", (Object)this.currentApplicationVersionId()).add("CloudWatchLoggingOptionId", (Object)this.cloudWatchLoggingOptionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.currentApplicationVersionId()));
            }
            case "CloudWatchLoggingOptionId": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("CurrentApplicationVersionId", CURRENT_APPLICATION_VERSION_ID_FIELD);
        map.put("CloudWatchLoggingOptionId", CLOUD_WATCH_LOGGING_OPTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationCloudWatchLoggingOptionRequest, T> g) {
        return obj -> g.apply((DeleteApplicationCloudWatchLoggingOptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private String cloudWatchLoggingOptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationCloudWatchLoggingOptionRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final String getCloudWatchLoggingOptionId() {
            return this.cloudWatchLoggingOptionId;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationCloudWatchLoggingOptionRequest build() {
            return new DeleteApplicationCloudWatchLoggingOptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder cloudWatchLoggingOptionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

