/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.Cors;
import software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType;
import software.amazon.awssdk.services.lambda.model.InvokeMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionUrlConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionUrlConfig> {
    private static final SdkField<String> FUNCTION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionUrl").getter(FunctionUrlConfig.getter(FunctionUrlConfig::functionUrl)).setter(FunctionUrlConfig.setter(Builder::functionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionUrl").build()}).build();
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionArn").getter(FunctionUrlConfig.getter(FunctionUrlConfig::functionArn)).setter(FunctionUrlConfig.setter(Builder::functionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(FunctionUrlConfig.getter(FunctionUrlConfig::creationTime)).setter(FunctionUrlConfig.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedTime").getter(FunctionUrlConfig.getter(FunctionUrlConfig::lastModifiedTime)).setter(FunctionUrlConfig.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Cors> CORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Cors").getter(FunctionUrlConfig.getter(FunctionUrlConfig::cors)).setter(FunctionUrlConfig.setter(Builder::cors)).constructor(Cors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cors").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(FunctionUrlConfig.getter(FunctionUrlConfig::authTypeAsString)).setter(FunctionUrlConfig.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<String> INVOKE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvokeMode").getter(FunctionUrlConfig.getter(FunctionUrlConfig::invokeModeAsString)).setter(FunctionUrlConfig.setter(Builder::invokeMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokeMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_URL_FIELD, FUNCTION_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, CORS_FIELD, AUTH_TYPE_FIELD, INVOKE_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunctionUrlConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String functionUrl;
    private final String functionArn;
    private final String creationTime;
    private final String lastModifiedTime;
    private final Cors cors;
    private final String authType;
    private final String invokeMode;

    private FunctionUrlConfig(BuilderImpl builder) {
        this.functionUrl = builder.functionUrl;
        this.functionArn = builder.functionArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.cors = builder.cors;
        this.authType = builder.authType;
        this.invokeMode = builder.invokeMode;
    }

    public final String functionUrl() {
        return this.functionUrl;
    }

    public final String functionArn() {
        return this.functionArn;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Cors cors() {
        return this.cors;
    }

    public final FunctionUrlAuthType authType() {
        return FunctionUrlAuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final InvokeMode invokeMode() {
        return InvokeMode.fromValue(this.invokeMode);
    }

    public final String invokeModeAsString() {
        return this.invokeMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.functionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cors());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokeModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionUrlConfig)) {
            return false;
        }
        FunctionUrlConfig other = (FunctionUrlConfig)obj;
        return Objects.equals(this.functionUrl(), other.functionUrl()) && Objects.equals(this.functionArn(), other.functionArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.cors(), other.cors()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.invokeModeAsString(), other.invokeModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionUrlConfig").add("FunctionUrl", (Object)this.functionUrl()).add("FunctionArn", (Object)this.functionArn()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Cors", (Object)this.cors()).add("AuthType", (Object)this.authTypeAsString()).add("InvokeMode", (Object)this.invokeModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionUrl": {
                return Optional.ofNullable(clazz.cast(this.functionUrl()));
            }
            case "FunctionArn": {
                return Optional.ofNullable(clazz.cast(this.functionArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Cors": {
                return Optional.ofNullable(clazz.cast(this.cors()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "InvokeMode": {
                return Optional.ofNullable(clazz.cast(this.invokeModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionUrl", FUNCTION_URL_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Cors", CORS_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("InvokeMode", INVOKE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionUrlConfig, T> g) {
        return obj -> g.apply((FunctionUrlConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String functionUrl;
        private String functionArn;
        private String creationTime;
        private String lastModifiedTime;
        private Cors cors;
        private String authType;
        private String invokeMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionUrlConfig model) {
            this.functionUrl(model.functionUrl);
            this.functionArn(model.functionArn);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.cors(model.cors);
            this.authType(model.authType);
            this.invokeMode(model.invokeMode);
        }

        public final String getFunctionUrl() {
            return this.functionUrl;
        }

        public final void setFunctionUrl(String functionUrl) {
            this.functionUrl = functionUrl;
        }

        @Override
        public final Builder functionUrl(String functionUrl) {
            this.functionUrl = functionUrl;
            return this;
        }

        public final String getFunctionArn() {
            return this.functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Cors.Builder getCors() {
            return this.cors != null ? this.cors.toBuilder() : null;
        }

        public final void setCors(Cors.BuilderImpl cors) {
            this.cors = cors != null ? cors.build() : null;
        }

        @Override
        public final Builder cors(Cors cors) {
            this.cors = cors;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(FunctionUrlAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getInvokeMode() {
            return this.invokeMode;
        }

        public final void setInvokeMode(String invokeMode) {
            this.invokeMode = invokeMode;
        }

        @Override
        public final Builder invokeMode(String invokeMode) {
            this.invokeMode = invokeMode;
            return this;
        }

        @Override
        public final Builder invokeMode(InvokeMode invokeMode) {
            this.invokeMode(invokeMode == null ? null : invokeMode.toString());
            return this;
        }

        public FunctionUrlConfig build() {
            return new FunctionUrlConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionUrlConfig> {
        public Builder functionUrl(String var1);

        public Builder functionArn(String var1);

        public Builder creationTime(String var1);

        public Builder lastModifiedTime(String var1);

        public Builder cors(Cors var1);

        default public Builder cors(Consumer<Cors.Builder> cors) {
            return this.cors((Cors)((Cors.Builder)Cors.builder().applyMutation(cors)).build());
        }

        public Builder authType(String var1);

        public Builder authType(FunctionUrlAuthType var1);

        public Builder invokeMode(String var1);

        public Builder invokeMode(InvokeMode var1);
    }
}

