/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.CallbackOptions;
import software.amazon.awssdk.services.lambda.model.ChainedInvokeOptions;
import software.amazon.awssdk.services.lambda.model.ContextOptions;
import software.amazon.awssdk.services.lambda.model.ErrorObject;
import software.amazon.awssdk.services.lambda.model.OperationAction;
import software.amazon.awssdk.services.lambda.model.OperationType;
import software.amazon.awssdk.services.lambda.model.StepOptions;
import software.amazon.awssdk.services.lambda.model.WaitOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OperationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OperationUpdate> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(OperationUpdate.getter(OperationUpdate::id)).setter(OperationUpdate.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> PARENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentId").getter(OperationUpdate.getter(OperationUpdate::parentId)).setter(OperationUpdate.setter(Builder::parentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OperationUpdate.getter(OperationUpdate::name)).setter(OperationUpdate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(OperationUpdate.getter(OperationUpdate::typeAsString)).setter(OperationUpdate.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> SUB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubType").getter(OperationUpdate.getter(OperationUpdate::subType)).setter(OperationUpdate.setter(Builder::subType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubType").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(OperationUpdate.getter(OperationUpdate::actionAsString)).setter(OperationUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Payload").getter(OperationUpdate.getter(OperationUpdate::payload)).setter(OperationUpdate.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()}).build();
    private static final SdkField<ErrorObject> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(OperationUpdate.getter(OperationUpdate::error)).setter(OperationUpdate.setter(Builder::error)).constructor(ErrorObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<ContextOptions> CONTEXT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContextOptions").getter(OperationUpdate.getter(OperationUpdate::contextOptions)).setter(OperationUpdate.setter(Builder::contextOptions)).constructor(ContextOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextOptions").build()}).build();
    private static final SdkField<StepOptions> STEP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepOptions").getter(OperationUpdate.getter(OperationUpdate::stepOptions)).setter(OperationUpdate.setter(Builder::stepOptions)).constructor(StepOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepOptions").build()}).build();
    private static final SdkField<WaitOptions> WAIT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WaitOptions").getter(OperationUpdate.getter(OperationUpdate::waitOptions)).setter(OperationUpdate.setter(Builder::waitOptions)).constructor(WaitOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitOptions").build()}).build();
    private static final SdkField<CallbackOptions> CALLBACK_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CallbackOptions").getter(OperationUpdate.getter(OperationUpdate::callbackOptions)).setter(OperationUpdate.setter(Builder::callbackOptions)).constructor(CallbackOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackOptions").build()}).build();
    private static final SdkField<ChainedInvokeOptions> CHAINED_INVOKE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChainedInvokeOptions").getter(OperationUpdate.getter(OperationUpdate::chainedInvokeOptions)).setter(OperationUpdate.setter(Builder::chainedInvokeOptions)).constructor(ChainedInvokeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainedInvokeOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PARENT_ID_FIELD, NAME_FIELD, TYPE_FIELD, SUB_TYPE_FIELD, ACTION_FIELD, PAYLOAD_FIELD, ERROR_FIELD, CONTEXT_OPTIONS_FIELD, STEP_OPTIONS_FIELD, WAIT_OPTIONS_FIELD, CALLBACK_OPTIONS_FIELD, CHAINED_INVOKE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OperationUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String parentId;
    private final String name;
    private final String type;
    private final String subType;
    private final String action;
    private final String payload;
    private final ErrorObject error;
    private final ContextOptions contextOptions;
    private final StepOptions stepOptions;
    private final WaitOptions waitOptions;
    private final CallbackOptions callbackOptions;
    private final ChainedInvokeOptions chainedInvokeOptions;

    private OperationUpdate(BuilderImpl builder) {
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.name = builder.name;
        this.type = builder.type;
        this.subType = builder.subType;
        this.action = builder.action;
        this.payload = builder.payload;
        this.error = builder.error;
        this.contextOptions = builder.contextOptions;
        this.stepOptions = builder.stepOptions;
        this.waitOptions = builder.waitOptions;
        this.callbackOptions = builder.callbackOptions;
        this.chainedInvokeOptions = builder.chainedInvokeOptions;
    }

    public final String id() {
        return this.id;
    }

    public final String parentId() {
        return this.parentId;
    }

    public final String name() {
        return this.name;
    }

    public final OperationType type() {
        return OperationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String subType() {
        return this.subType;
    }

    public final OperationAction action() {
        return OperationAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String payload() {
        return this.payload;
    }

    public final ErrorObject error() {
        return this.error;
    }

    public final ContextOptions contextOptions() {
        return this.contextOptions;
    }

    public final StepOptions stepOptions() {
        return this.stepOptions;
    }

    public final WaitOptions waitOptions() {
        return this.waitOptions;
    }

    public final CallbackOptions callbackOptions() {
        return this.callbackOptions;
    }

    public final ChainedInvokeOptions chainedInvokeOptions() {
        return this.chainedInvokeOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subType());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.chainedInvokeOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationUpdate)) {
            return false;
        }
        OperationUpdate other = (OperationUpdate)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.parentId(), other.parentId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.subType(), other.subType()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.contextOptions(), other.contextOptions()) && Objects.equals(this.stepOptions(), other.stepOptions()) && Objects.equals(this.waitOptions(), other.waitOptions()) && Objects.equals(this.callbackOptions(), other.callbackOptions()) && Objects.equals(this.chainedInvokeOptions(), other.chainedInvokeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"OperationUpdate").add("Id", (Object)this.id()).add("ParentId", (Object)this.parentId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("SubType", (Object)this.subType()).add("Action", (Object)this.actionAsString()).add("Payload", (Object)(this.payload() == null ? null : "*** Sensitive Data Redacted ***")).add("Error", (Object)this.error()).add("ContextOptions", (Object)this.contextOptions()).add("StepOptions", (Object)this.stepOptions()).add("WaitOptions", (Object)this.waitOptions()).add("CallbackOptions", (Object)this.callbackOptions()).add("ChainedInvokeOptions", (Object)this.chainedInvokeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ParentId": {
                return Optional.ofNullable(clazz.cast(this.parentId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SubType": {
                return Optional.ofNullable(clazz.cast(this.subType()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "ContextOptions": {
                return Optional.ofNullable(clazz.cast(this.contextOptions()));
            }
            case "StepOptions": {
                return Optional.ofNullable(clazz.cast(this.stepOptions()));
            }
            case "WaitOptions": {
                return Optional.ofNullable(clazz.cast(this.waitOptions()));
            }
            case "CallbackOptions": {
                return Optional.ofNullable(clazz.cast(this.callbackOptions()));
            }
            case "ChainedInvokeOptions": {
                return Optional.ofNullable(clazz.cast(this.chainedInvokeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ParentId", PARENT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SubType", SUB_TYPE_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ContextOptions", CONTEXT_OPTIONS_FIELD);
        map.put("StepOptions", STEP_OPTIONS_FIELD);
        map.put("WaitOptions", WAIT_OPTIONS_FIELD);
        map.put("CallbackOptions", CALLBACK_OPTIONS_FIELD);
        map.put("ChainedInvokeOptions", CHAINED_INVOKE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OperationUpdate, T> g) {
        return obj -> g.apply((OperationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String parentId;
        private String name;
        private String type;
        private String subType;
        private String action;
        private String payload;
        private ErrorObject error;
        private ContextOptions contextOptions;
        private StepOptions stepOptions;
        private WaitOptions waitOptions;
        private CallbackOptions callbackOptions;
        private ChainedInvokeOptions chainedInvokeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationUpdate model) {
            this.id(model.id);
            this.parentId(model.parentId);
            this.name(model.name);
            this.type(model.type);
            this.subType(model.subType);
            this.action(model.action);
            this.payload(model.payload);
            this.error(model.error);
            this.contextOptions(model.contextOptions);
            this.stepOptions(model.stepOptions);
            this.waitOptions(model.waitOptions);
            this.callbackOptions(model.callbackOptions);
            this.chainedInvokeOptions(model.chainedInvokeOptions);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getParentId() {
            return this.parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSubType() {
            return this.subType;
        }

        public final void setSubType(String subType) {
            this.subType = subType;
        }

        @Override
        public final Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(OperationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getPayload() {
            return this.payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final ErrorObject.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorObject.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorObject error) {
            this.error = error;
            return this;
        }

        public final ContextOptions.Builder getContextOptions() {
            return this.contextOptions != null ? this.contextOptions.toBuilder() : null;
        }

        public final void setContextOptions(ContextOptions.BuilderImpl contextOptions) {
            this.contextOptions = contextOptions != null ? contextOptions.build() : null;
        }

        @Override
        public final Builder contextOptions(ContextOptions contextOptions) {
            this.contextOptions = contextOptions;
            return this;
        }

        public final StepOptions.Builder getStepOptions() {
            return this.stepOptions != null ? this.stepOptions.toBuilder() : null;
        }

        public final void setStepOptions(StepOptions.BuilderImpl stepOptions) {
            this.stepOptions = stepOptions != null ? stepOptions.build() : null;
        }

        @Override
        public final Builder stepOptions(StepOptions stepOptions) {
            this.stepOptions = stepOptions;
            return this;
        }

        public final WaitOptions.Builder getWaitOptions() {
            return this.waitOptions != null ? this.waitOptions.toBuilder() : null;
        }

        public final void setWaitOptions(WaitOptions.BuilderImpl waitOptions) {
            this.waitOptions = waitOptions != null ? waitOptions.build() : null;
        }

        @Override
        public final Builder waitOptions(WaitOptions waitOptions) {
            this.waitOptions = waitOptions;
            return this;
        }

        public final CallbackOptions.Builder getCallbackOptions() {
            return this.callbackOptions != null ? this.callbackOptions.toBuilder() : null;
        }

        public final void setCallbackOptions(CallbackOptions.BuilderImpl callbackOptions) {
            this.callbackOptions = callbackOptions != null ? callbackOptions.build() : null;
        }

        @Override
        public final Builder callbackOptions(CallbackOptions callbackOptions) {
            this.callbackOptions = callbackOptions;
            return this;
        }

        public final ChainedInvokeOptions.Builder getChainedInvokeOptions() {
            return this.chainedInvokeOptions != null ? this.chainedInvokeOptions.toBuilder() : null;
        }

        public final void setChainedInvokeOptions(ChainedInvokeOptions.BuilderImpl chainedInvokeOptions) {
            this.chainedInvokeOptions = chainedInvokeOptions != null ? chainedInvokeOptions.build() : null;
        }

        @Override
        public final Builder chainedInvokeOptions(ChainedInvokeOptions chainedInvokeOptions) {
            this.chainedInvokeOptions = chainedInvokeOptions;
            return this;
        }

        public OperationUpdate build() {
            return new OperationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OperationUpdate> {
        public Builder id(String var1);

        public Builder parentId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(OperationType var1);

        public Builder subType(String var1);

        public Builder action(String var1);

        public Builder action(OperationAction var1);

        public Builder payload(String var1);

        public Builder error(ErrorObject var1);

        default public Builder error(Consumer<ErrorObject.Builder> error) {
            return this.error((ErrorObject)((ErrorObject.Builder)ErrorObject.builder().applyMutation(error)).build());
        }

        public Builder contextOptions(ContextOptions var1);

        default public Builder contextOptions(Consumer<ContextOptions.Builder> contextOptions) {
            return this.contextOptions((ContextOptions)((ContextOptions.Builder)ContextOptions.builder().applyMutation(contextOptions)).build());
        }

        public Builder stepOptions(StepOptions var1);

        default public Builder stepOptions(Consumer<StepOptions.Builder> stepOptions) {
            return this.stepOptions((StepOptions)((StepOptions.Builder)StepOptions.builder().applyMutation(stepOptions)).build());
        }

        public Builder waitOptions(WaitOptions var1);

        default public Builder waitOptions(Consumer<WaitOptions.Builder> waitOptions) {
            return this.waitOptions((WaitOptions)((WaitOptions.Builder)WaitOptions.builder().applyMutation(waitOptions)).build());
        }

        public Builder callbackOptions(CallbackOptions var1);

        default public Builder callbackOptions(Consumer<CallbackOptions.Builder> callbackOptions) {
            return this.callbackOptions((CallbackOptions)((CallbackOptions.Builder)CallbackOptions.builder().applyMutation(callbackOptions)).build());
        }

        public Builder chainedInvokeOptions(ChainedInvokeOptions var1);

        default public Builder chainedInvokeOptions(Consumer<ChainedInvokeOptions.Builder> chainedInvokeOptions) {
            return this.chainedInvokeOptions((ChainedInvokeOptions)((ChainedInvokeOptions.Builder)ChainedInvokeOptions.builder().applyMutation(chainedInvokeOptions)).build());
        }
    }
}

