/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.SubnetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateSettings> {
    private static final SdkField<List<String>> ADD_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddSubnets").getter(UpdateSettings.getter(UpdateSettings::addSubnets)).setter(UpdateSettings.setter(Builder::addSubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveSubnets").getter(UpdateSettings.getter(UpdateSettings::removeSubnets)).setter(UpdateSettings.setter(Builder::removeSubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupId").getter(UpdateSettings.getter(UpdateSettings::securityGroupId)).setter(UpdateSettings.setter(Builder::securityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_SUBNETS_FIELD, REMOVE_SUBNETS_FIELD, SECURITY_GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> addSubnets;
    private final List<String> removeSubnets;
    private final String securityGroupId;

    private UpdateSettings(BuilderImpl builder) {
        this.addSubnets = builder.addSubnets;
        this.removeSubnets = builder.removeSubnets;
        this.securityGroupId = builder.securityGroupId;
    }

    public final boolean hasAddSubnets() {
        return this.addSubnets != null && !(this.addSubnets instanceof SdkAutoConstructList);
    }

    public final List<String> addSubnets() {
        return this.addSubnets;
    }

    public final boolean hasRemoveSubnets() {
        return this.removeSubnets != null && !(this.removeSubnets instanceof SdkAutoConstructList);
    }

    public final List<String> removeSubnets() {
        return this.removeSubnets;
    }

    public final String securityGroupId() {
        return this.securityGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSubnets() ? this.addSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSubnets() ? this.removeSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSettings)) {
            return false;
        }
        UpdateSettings other = (UpdateSettings)obj;
        return this.hasAddSubnets() == other.hasAddSubnets() && Objects.equals(this.addSubnets(), other.addSubnets()) && this.hasRemoveSubnets() == other.hasRemoveSubnets() && Objects.equals(this.removeSubnets(), other.removeSubnets()) && Objects.equals(this.securityGroupId(), other.securityGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSettings").add("AddSubnets", this.hasAddSubnets() ? this.addSubnets() : null).add("RemoveSubnets", this.hasRemoveSubnets() ? this.removeSubnets() : null).add("SecurityGroupId", (Object)this.securityGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddSubnets": {
                return Optional.ofNullable(clazz.cast(this.addSubnets()));
            }
            case "RemoveSubnets": {
                return Optional.ofNullable(clazz.cast(this.removeSubnets()));
            }
            case "SecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.securityGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddSubnets", ADD_SUBNETS_FIELD);
        map.put("RemoveSubnets", REMOVE_SUBNETS_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSettings, T> g) {
        return obj -> g.apply((UpdateSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> addSubnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSubnets = DefaultSdkAutoConstructList.getInstance();
        private String securityGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSettings model) {
            this.addSubnets(model.addSubnets);
            this.removeSubnets(model.removeSubnets);
            this.securityGroupId(model.securityGroupId);
        }

        public final Collection<String> getAddSubnets() {
            if (this.addSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSubnets;
        }

        public final void setAddSubnets(Collection<String> addSubnets) {
            this.addSubnets = SubnetsCopier.copy(addSubnets);
        }

        @Override
        public final Builder addSubnets(Collection<String> addSubnets) {
            this.addSubnets = SubnetsCopier.copy(addSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnets(String ... addSubnets) {
            this.addSubnets(Arrays.asList(addSubnets));
            return this;
        }

        public final Collection<String> getRemoveSubnets() {
            if (this.removeSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSubnets;
        }

        public final void setRemoveSubnets(Collection<String> removeSubnets) {
            this.removeSubnets = SubnetsCopier.copy(removeSubnets);
        }

        @Override
        public final Builder removeSubnets(Collection<String> removeSubnets) {
            this.removeSubnets = SubnetsCopier.copy(removeSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnets(String ... removeSubnets) {
            this.removeSubnets(Arrays.asList(removeSubnets));
            return this;
        }

        public final String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public final void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @Override
        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        public UpdateSettings build() {
            return new UpdateSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateSettings> {
        public Builder addSubnets(Collection<String> var1);

        public Builder addSubnets(String ... var1);

        public Builder removeSubnets(Collection<String> var1);

        public Builder removeSubnets(String ... var1);

        public Builder securityGroupId(String var1);
    }
}

