/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.machinelearning.MachineLearningAsyncClient;
import software.amazon.awssdk.services.machinelearning.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningRequest;
import software.amazon.awssdk.services.machinelearning.waiters.MachineLearningAsyncWaiter;
import software.amazon.awssdk.services.machinelearning.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultMachineLearningAsyncWaiter
implements MachineLearningAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final MachineLearningAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeDataSourcesResponse> dataSourceAvailableWaiter;
    private final AsyncWaiter<DescribeMlModelsResponse> mLModelAvailableWaiter;
    private final AsyncWaiter<DescribeEvaluationsResponse> evaluationAvailableWaiter;
    private final AsyncWaiter<DescribeBatchPredictionsResponse> batchPredictionAvailableWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultMachineLearningAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (MachineLearningAsyncClient)MachineLearningAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.dataSourceAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDataSourcesResponse.class).acceptors(DefaultMachineLearningAsyncWaiter.dataSourceAvailableWaiterAcceptors())).overrideConfiguration(DefaultMachineLearningAsyncWaiter.dataSourceAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.mLModelAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeMlModelsResponse.class).acceptors(DefaultMachineLearningAsyncWaiter.mLModelAvailableWaiterAcceptors())).overrideConfiguration(DefaultMachineLearningAsyncWaiter.mLModelAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.evaluationAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeEvaluationsResponse.class).acceptors(DefaultMachineLearningAsyncWaiter.evaluationAvailableWaiterAcceptors())).overrideConfiguration(DefaultMachineLearningAsyncWaiter.evaluationAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.batchPredictionAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeBatchPredictionsResponse.class).acceptors(DefaultMachineLearningAsyncWaiter.batchPredictionAvailableWaiterAcceptors())).overrideConfiguration(DefaultMachineLearningAsyncWaiter.batchPredictionAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBatchPredictionsResponse>> waitUntilBatchPredictionAvailable(DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        return this.batchPredictionAvailableWaiter.runAsync(() -> this.client.describeBatchPredictions(this.applyWaitersUserAgent(describeBatchPredictionsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBatchPredictionsResponse>> waitUntilBatchPredictionAvailable(DescribeBatchPredictionsRequest describeBatchPredictionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.batchPredictionAvailableWaiter.runAsync(() -> this.client.describeBatchPredictions(this.applyWaitersUserAgent(describeBatchPredictionsRequest)), DefaultMachineLearningAsyncWaiter.batchPredictionAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDataSourcesResponse>> waitUntilDataSourceAvailable(DescribeDataSourcesRequest describeDataSourcesRequest) {
        return this.dataSourceAvailableWaiter.runAsync(() -> this.client.describeDataSources(this.applyWaitersUserAgent(describeDataSourcesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDataSourcesResponse>> waitUntilDataSourceAvailable(DescribeDataSourcesRequest describeDataSourcesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dataSourceAvailableWaiter.runAsync(() -> this.client.describeDataSources(this.applyWaitersUserAgent(describeDataSourcesRequest)), DefaultMachineLearningAsyncWaiter.dataSourceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEvaluationsResponse>> waitUntilEvaluationAvailable(DescribeEvaluationsRequest describeEvaluationsRequest) {
        return this.evaluationAvailableWaiter.runAsync(() -> this.client.describeEvaluations(this.applyWaitersUserAgent(describeEvaluationsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEvaluationsResponse>> waitUntilEvaluationAvailable(DescribeEvaluationsRequest describeEvaluationsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.evaluationAvailableWaiter.runAsync(() -> this.client.describeEvaluations(this.applyWaitersUserAgent(describeEvaluationsRequest)), DefaultMachineLearningAsyncWaiter.evaluationAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMlModelsResponse>> waitUntilMLModelAvailable(DescribeMlModelsRequest describeMlModelsRequest) {
        return this.mLModelAvailableWaiter.runAsync(() -> this.client.describeMLModels(this.applyWaitersUserAgent(describeMlModelsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMlModelsResponse>> waitUntilMLModelAvailable(DescribeMlModelsRequest describeMlModelsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.mLModelAvailableWaiter.runAsync(() -> this.client.describeMLModels(this.applyWaitersUserAgent(describeMlModelsRequest)), DefaultMachineLearningAsyncWaiter.mLModelAvailableWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeDataSourcesResponse>> dataSourceAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDataSourcesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDataSourcesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Results[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMlModelsResponse>> mLModelAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMlModelsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMlModelsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Results[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEvaluationsResponse>> evaluationAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEvaluationsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEvaluationsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Results[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBatchPredictionsResponse>> batchPredictionAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBatchPredictionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBatchPredictionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "COMPLETED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Results").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "FAILED"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Results[].Status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration dataSourceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration mLModelAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration evaluationAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration batchPredictionAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static MachineLearningAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends MachineLearningRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MachineLearningRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements MachineLearningAsyncWaiter.Builder {
        private MachineLearningAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public MachineLearningAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public MachineLearningAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public MachineLearningAsyncWaiter.Builder client(MachineLearningAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public MachineLearningAsyncWaiter build() {
            return new DefaultMachineLearningAsyncWaiter(this);
        }
    }
}

