/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchainquery.model.AssetContract;
import software.amazon.awssdk.services.managedblockchainquery.model.AssetContractListCopier;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetContractsResponse
extends ManagedBlockchainQueryResponse
implements ToCopyableBuilder<Builder, ListAssetContractsResponse> {
    private static final SdkField<List<AssetContract>> CONTRACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contracts").getter(ListAssetContractsResponse.getter(ListAssetContractsResponse::contracts)).setter(ListAssetContractsResponse.setter(Builder::contracts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contracts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetContract::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssetContractsResponse.getter(ListAssetContractsResponse::nextToken)).setter(ListAssetContractsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRACTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssetContractsResponse.memberNameToFieldInitializer();
    private final List<AssetContract> contracts;
    private final String nextToken;

    private ListAssetContractsResponse(BuilderImpl builder) {
        super(builder);
        this.contracts = builder.contracts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContracts() {
        return this.contracts != null && !(this.contracts instanceof SdkAutoConstructList);
    }

    public final List<AssetContract> contracts() {
        return this.contracts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContracts() ? this.contracts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetContractsResponse)) {
            return false;
        }
        ListAssetContractsResponse other = (ListAssetContractsResponse)((Object)obj);
        return this.hasContracts() == other.hasContracts() && Objects.equals(this.contracts(), other.contracts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetContractsResponse").add("Contracts", this.hasContracts() ? this.contracts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contracts": {
                return Optional.ofNullable(clazz.cast(this.contracts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contracts", CONTRACTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssetContractsResponse, T> g) {
        return obj -> g.apply((ListAssetContractsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryResponse.BuilderImpl
    implements Builder {
        private List<AssetContract> contracts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetContractsResponse model) {
            super(model);
            this.contracts(model.contracts);
            this.nextToken(model.nextToken);
        }

        public final List<AssetContract.Builder> getContracts() {
            List<AssetContract.Builder> result = AssetContractListCopier.copyToBuilder(this.contracts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContracts(Collection<AssetContract.BuilderImpl> contracts) {
            this.contracts = AssetContractListCopier.copyFromBuilder(contracts);
        }

        @Override
        public final Builder contracts(Collection<AssetContract> contracts) {
            this.contracts = AssetContractListCopier.copy(contracts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contracts(AssetContract ... contracts) {
            this.contracts(Arrays.asList(contracts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contracts(Consumer<AssetContract.Builder> ... contracts) {
            this.contracts(Stream.of(contracts).map(c -> (AssetContract)((AssetContract.Builder)AssetContract.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssetContractsResponse build() {
            return new ListAssetContractsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ManagedBlockchainQueryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetContractsResponse> {
        public Builder contracts(Collection<AssetContract> var1);

        public Builder contracts(AssetContract ... var1);

        public Builder contracts(Consumer<AssetContract.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

