/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant;
import software.amazon.awssdk.services.managedblockchainquery.model.ConfirmationStatus;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryTransactionEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransactionEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransactionEvent> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("network").getter(TransactionEvent.getter(TransactionEvent::networkAsString)).setter(TransactionEvent.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionHash").getter(TransactionEvent.getter(TransactionEvent::transactionHash)).setter(TransactionEvent.setter(Builder::transactionHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(TransactionEvent.getter(TransactionEvent::eventTypeAsString)).setter(TransactionEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("from").getter(TransactionEvent.getter(TransactionEvent::from)).setter(TransactionEvent.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()}).build();
    private static final SdkField<String> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("to").getter(TransactionEvent.getter(TransactionEvent::to)).setter(TransactionEvent.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(TransactionEvent.getter(TransactionEvent::value)).setter(TransactionEvent.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<String> CONTRACT_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contractAddress").getter(TransactionEvent.getter(TransactionEvent::contractAddress)).setter(TransactionEvent.setter(Builder::contractAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractAddress").build()}).build();
    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenId").getter(TransactionEvent.getter(TransactionEvent::tokenId)).setter(TransactionEvent.setter(Builder::tokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenId").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionId").getter(TransactionEvent.getter(TransactionEvent::transactionId)).setter(TransactionEvent.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()}).build();
    private static final SdkField<Integer> VOUT_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("voutIndex").getter(TransactionEvent.getter(TransactionEvent::voutIndex)).setter(TransactionEvent.setter(Builder::voutIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voutIndex").build()}).build();
    private static final SdkField<Boolean> VOUT_SPENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("voutSpent").getter(TransactionEvent.getter(TransactionEvent::voutSpent)).setter(TransactionEvent.setter(Builder::voutSpent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voutSpent").build()}).build();
    private static final SdkField<String> SPENT_VOUT_TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spentVoutTransactionId").getter(TransactionEvent.getter(TransactionEvent::spentVoutTransactionId)).setter(TransactionEvent.setter(Builder::spentVoutTransactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spentVoutTransactionId").build()}).build();
    private static final SdkField<String> SPENT_VOUT_TRANSACTION_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("spentVoutTransactionHash").getter(TransactionEvent.getter(TransactionEvent::spentVoutTransactionHash)).setter(TransactionEvent.setter(Builder::spentVoutTransactionHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spentVoutTransactionHash").build()}).build();
    private static final SdkField<Integer> SPENT_VOUT_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("spentVoutIndex").getter(TransactionEvent.getter(TransactionEvent::spentVoutIndex)).setter(TransactionEvent.setter(Builder::spentVoutIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spentVoutIndex").build()}).build();
    private static final SdkField<BlockchainInstant> BLOCKCHAIN_INSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("blockchainInstant").getter(TransactionEvent.getter(TransactionEvent::blockchainInstant)).setter(TransactionEvent.setter(Builder::blockchainInstant)).constructor(BlockchainInstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockchainInstant").build()}).build();
    private static final SdkField<String> CONFIRMATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confirmationStatus").getter(TransactionEvent.getter(TransactionEvent::confirmationStatusAsString)).setter(TransactionEvent.setter(Builder::confirmationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD, TRANSACTION_HASH_FIELD, EVENT_TYPE_FIELD, FROM_FIELD, TO_FIELD, VALUE_FIELD, CONTRACT_ADDRESS_FIELD, TOKEN_ID_FIELD, TRANSACTION_ID_FIELD, VOUT_INDEX_FIELD, VOUT_SPENT_FIELD, SPENT_VOUT_TRANSACTION_ID_FIELD, SPENT_VOUT_TRANSACTION_HASH_FIELD, SPENT_VOUT_INDEX_FIELD, BLOCKCHAIN_INSTANT_FIELD, CONFIRMATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransactionEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String network;
    private final String transactionHash;
    private final String eventType;
    private final String from;
    private final String to;
    private final String value;
    private final String contractAddress;
    private final String tokenId;
    private final String transactionId;
    private final Integer voutIndex;
    private final Boolean voutSpent;
    private final String spentVoutTransactionId;
    private final String spentVoutTransactionHash;
    private final Integer spentVoutIndex;
    private final BlockchainInstant blockchainInstant;
    private final String confirmationStatus;

    private TransactionEvent(BuilderImpl builder) {
        this.network = builder.network;
        this.transactionHash = builder.transactionHash;
        this.eventType = builder.eventType;
        this.from = builder.from;
        this.to = builder.to;
        this.value = builder.value;
        this.contractAddress = builder.contractAddress;
        this.tokenId = builder.tokenId;
        this.transactionId = builder.transactionId;
        this.voutIndex = builder.voutIndex;
        this.voutSpent = builder.voutSpent;
        this.spentVoutTransactionId = builder.spentVoutTransactionId;
        this.spentVoutTransactionHash = builder.spentVoutTransactionHash;
        this.spentVoutIndex = builder.spentVoutIndex;
        this.blockchainInstant = builder.blockchainInstant;
        this.confirmationStatus = builder.confirmationStatus;
    }

    public final QueryNetwork network() {
        return QueryNetwork.fromValue(this.network);
    }

    public final String networkAsString() {
        return this.network;
    }

    public final String transactionHash() {
        return this.transactionHash;
    }

    public final QueryTransactionEventType eventType() {
        return QueryTransactionEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final String from() {
        return this.from;
    }

    public final String to() {
        return this.to;
    }

    public final String value() {
        return this.value;
    }

    public final String contractAddress() {
        return this.contractAddress;
    }

    public final String tokenId() {
        return this.tokenId;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final Integer voutIndex() {
        return this.voutIndex;
    }

    public final Boolean voutSpent() {
        return this.voutSpent;
    }

    public final String spentVoutTransactionId() {
        return this.spentVoutTransactionId;
    }

    public final String spentVoutTransactionHash() {
        return this.spentVoutTransactionHash;
    }

    public final Integer spentVoutIndex() {
        return this.spentVoutIndex;
    }

    public final BlockchainInstant blockchainInstant() {
        return this.blockchainInstant;
    }

    public final ConfirmationStatus confirmationStatus() {
        return ConfirmationStatus.fromValue(this.confirmationStatus);
    }

    public final String confirmationStatusAsString() {
        return this.confirmationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.contractAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.voutIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.voutSpent());
        hashCode = 31 * hashCode + Objects.hashCode(this.spentVoutTransactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spentVoutTransactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.spentVoutIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionEvent)) {
            return false;
        }
        TransactionEvent other = (TransactionEvent)obj;
        return Objects.equals(this.networkAsString(), other.networkAsString()) && Objects.equals(this.transactionHash(), other.transactionHash()) && Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.contractAddress(), other.contractAddress()) && Objects.equals(this.tokenId(), other.tokenId()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.voutIndex(), other.voutIndex()) && Objects.equals(this.voutSpent(), other.voutSpent()) && Objects.equals(this.spentVoutTransactionId(), other.spentVoutTransactionId()) && Objects.equals(this.spentVoutTransactionHash(), other.spentVoutTransactionHash()) && Objects.equals(this.spentVoutIndex(), other.spentVoutIndex()) && Objects.equals(this.blockchainInstant(), other.blockchainInstant()) && Objects.equals(this.confirmationStatusAsString(), other.confirmationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransactionEvent").add("Network", (Object)this.networkAsString()).add("TransactionHash", (Object)this.transactionHash()).add("EventType", (Object)this.eventTypeAsString()).add("From", (Object)this.from()).add("To", (Object)this.to()).add("Value", (Object)this.value()).add("ContractAddress", (Object)this.contractAddress()).add("TokenId", (Object)this.tokenId()).add("TransactionId", (Object)this.transactionId()).add("VoutIndex", (Object)this.voutIndex()).add("VoutSpent", (Object)this.voutSpent()).add("SpentVoutTransactionId", (Object)this.spentVoutTransactionId()).add("SpentVoutTransactionHash", (Object)this.spentVoutTransactionHash()).add("SpentVoutIndex", (Object)this.spentVoutIndex()).add("BlockchainInstant", (Object)this.blockchainInstant()).add("ConfirmationStatus", (Object)this.confirmationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "network": {
                return Optional.ofNullable(clazz.cast(this.networkAsString()));
            }
            case "transactionHash": {
                return Optional.ofNullable(clazz.cast(this.transactionHash()));
            }
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "from": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "to": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "contractAddress": {
                return Optional.ofNullable(clazz.cast(this.contractAddress()));
            }
            case "tokenId": {
                return Optional.ofNullable(clazz.cast(this.tokenId()));
            }
            case "transactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "voutIndex": {
                return Optional.ofNullable(clazz.cast(this.voutIndex()));
            }
            case "voutSpent": {
                return Optional.ofNullable(clazz.cast(this.voutSpent()));
            }
            case "spentVoutTransactionId": {
                return Optional.ofNullable(clazz.cast(this.spentVoutTransactionId()));
            }
            case "spentVoutTransactionHash": {
                return Optional.ofNullable(clazz.cast(this.spentVoutTransactionHash()));
            }
            case "spentVoutIndex": {
                return Optional.ofNullable(clazz.cast(this.spentVoutIndex()));
            }
            case "blockchainInstant": {
                return Optional.ofNullable(clazz.cast(this.blockchainInstant()));
            }
            case "confirmationStatus": {
                return Optional.ofNullable(clazz.cast(this.confirmationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("network", NETWORK_FIELD);
        map.put("transactionHash", TRANSACTION_HASH_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("from", FROM_FIELD);
        map.put("to", TO_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("contractAddress", CONTRACT_ADDRESS_FIELD);
        map.put("tokenId", TOKEN_ID_FIELD);
        map.put("transactionId", TRANSACTION_ID_FIELD);
        map.put("voutIndex", VOUT_INDEX_FIELD);
        map.put("voutSpent", VOUT_SPENT_FIELD);
        map.put("spentVoutTransactionId", SPENT_VOUT_TRANSACTION_ID_FIELD);
        map.put("spentVoutTransactionHash", SPENT_VOUT_TRANSACTION_HASH_FIELD);
        map.put("spentVoutIndex", SPENT_VOUT_INDEX_FIELD);
        map.put("blockchainInstant", BLOCKCHAIN_INSTANT_FIELD);
        map.put("confirmationStatus", CONFIRMATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransactionEvent, T> g) {
        return obj -> g.apply((TransactionEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String network;
        private String transactionHash;
        private String eventType;
        private String from;
        private String to;
        private String value;
        private String contractAddress;
        private String tokenId;
        private String transactionId;
        private Integer voutIndex;
        private Boolean voutSpent;
        private String spentVoutTransactionId;
        private String spentVoutTransactionHash;
        private Integer spentVoutIndex;
        private BlockchainInstant blockchainInstant;
        private String confirmationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionEvent model) {
            this.network(model.network);
            this.transactionHash(model.transactionHash);
            this.eventType(model.eventType);
            this.from(model.from);
            this.to(model.to);
            this.value(model.value);
            this.contractAddress(model.contractAddress);
            this.tokenId(model.tokenId);
            this.transactionId(model.transactionId);
            this.voutIndex(model.voutIndex);
            this.voutSpent(model.voutSpent);
            this.spentVoutTransactionId(model.spentVoutTransactionId);
            this.spentVoutTransactionHash(model.spentVoutTransactionHash);
            this.spentVoutIndex(model.spentVoutIndex);
            this.blockchainInstant(model.blockchainInstant);
            this.confirmationStatus(model.confirmationStatus);
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getTransactionHash() {
            return this.transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(QueryTransactionEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getFrom() {
            return this.from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getTo() {
            return this.to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getContractAddress() {
            return this.contractAddress;
        }

        public final void setContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
        }

        @Override
        public final Builder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public final String getTokenId() {
            return this.tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Integer getVoutIndex() {
            return this.voutIndex;
        }

        public final void setVoutIndex(Integer voutIndex) {
            this.voutIndex = voutIndex;
        }

        @Override
        public final Builder voutIndex(Integer voutIndex) {
            this.voutIndex = voutIndex;
            return this;
        }

        public final Boolean getVoutSpent() {
            return this.voutSpent;
        }

        public final void setVoutSpent(Boolean voutSpent) {
            this.voutSpent = voutSpent;
        }

        @Override
        public final Builder voutSpent(Boolean voutSpent) {
            this.voutSpent = voutSpent;
            return this;
        }

        public final String getSpentVoutTransactionId() {
            return this.spentVoutTransactionId;
        }

        public final void setSpentVoutTransactionId(String spentVoutTransactionId) {
            this.spentVoutTransactionId = spentVoutTransactionId;
        }

        @Override
        public final Builder spentVoutTransactionId(String spentVoutTransactionId) {
            this.spentVoutTransactionId = spentVoutTransactionId;
            return this;
        }

        public final String getSpentVoutTransactionHash() {
            return this.spentVoutTransactionHash;
        }

        public final void setSpentVoutTransactionHash(String spentVoutTransactionHash) {
            this.spentVoutTransactionHash = spentVoutTransactionHash;
        }

        @Override
        public final Builder spentVoutTransactionHash(String spentVoutTransactionHash) {
            this.spentVoutTransactionHash = spentVoutTransactionHash;
            return this;
        }

        public final Integer getSpentVoutIndex() {
            return this.spentVoutIndex;
        }

        public final void setSpentVoutIndex(Integer spentVoutIndex) {
            this.spentVoutIndex = spentVoutIndex;
        }

        @Override
        public final Builder spentVoutIndex(Integer spentVoutIndex) {
            this.spentVoutIndex = spentVoutIndex;
            return this;
        }

        public final BlockchainInstant.Builder getBlockchainInstant() {
            return this.blockchainInstant != null ? this.blockchainInstant.toBuilder() : null;
        }

        public final void setBlockchainInstant(BlockchainInstant.BuilderImpl blockchainInstant) {
            this.blockchainInstant = blockchainInstant != null ? blockchainInstant.build() : null;
        }

        @Override
        public final Builder blockchainInstant(BlockchainInstant blockchainInstant) {
            this.blockchainInstant = blockchainInstant;
            return this;
        }

        public final String getConfirmationStatus() {
            return this.confirmationStatus;
        }

        public final void setConfirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
        }

        @Override
        public final Builder confirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        @Override
        public final Builder confirmationStatus(ConfirmationStatus confirmationStatus) {
            this.confirmationStatus(confirmationStatus == null ? null : confirmationStatus.toString());
            return this;
        }

        public TransactionEvent build() {
            return new TransactionEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransactionEvent> {
        public Builder network(String var1);

        public Builder network(QueryNetwork var1);

        public Builder transactionHash(String var1);

        public Builder eventType(String var1);

        public Builder eventType(QueryTransactionEventType var1);

        public Builder from(String var1);

        public Builder to(String var1);

        public Builder value(String var1);

        public Builder contractAddress(String var1);

        public Builder tokenId(String var1);

        public Builder transactionId(String var1);

        public Builder voutIndex(Integer var1);

        public Builder voutSpent(Boolean var1);

        public Builder spentVoutTransactionId(String var1);

        public Builder spentVoutTransactionHash(String var1);

        public Builder spentVoutIndex(Integer var1);

        public Builder blockchainInstant(BlockchainInstant var1);

        default public Builder blockchainInstant(Consumer<BlockchainInstant.Builder> blockchainInstant) {
            return this.blockchainInstant((BlockchainInstant)((BlockchainInstant.Builder)BlockchainInstant.builder().applyMutation(blockchainInstant)).build());
        }

        public Builder confirmationStatus(String var1);

        public Builder confirmationStatus(ConfirmationStatus var1);
    }
}

