/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceSubType {
    DATABASE("Database"),
    PROCESS("Process"),
    DATABASE_PROCESS("DatabaseProcess"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceSubType> VALUE_MAP;
    private final String value;

    private ResourceSubType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceSubType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceSubType> knownValues() {
        EnumSet<ResourceSubType> knownValues = EnumSet.allOf(ResourceSubType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceSubType.class, ResourceSubType::toString);
    }
}

