/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.ChangeType;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPendingChanges
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPendingChanges> {
    private static final SdkField<Boolean> CONSOLE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConsoleAccess").getter(UserPendingChanges.getter(UserPendingChanges::consoleAccess)).setter(UserPendingChanges.setter(Builder::consoleAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleAccess").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(UserPendingChanges.getter(UserPendingChanges::groups)).setter(UserPendingChanges.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PENDING_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PendingChange").getter(UserPendingChanges.getter(UserPendingChanges::pendingChangeAsString)).setter(UserPendingChanges.setter(Builder::pendingChange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingChange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSOLE_ACCESS_FIELD, GROUPS_FIELD, PENDING_CHANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserPendingChanges.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean consoleAccess;
    private final List<String> groups;
    private final String pendingChange;

    private UserPendingChanges(BuilderImpl builder) {
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.pendingChange = builder.pendingChange;
    }

    public final Boolean consoleAccess() {
        return this.consoleAccess;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final ChangeType pendingChange() {
        return ChangeType.fromValue(this.pendingChange);
    }

    public final String pendingChangeAsString() {
        return this.pendingChange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingChangeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPendingChanges)) {
            return false;
        }
        UserPendingChanges other = (UserPendingChanges)obj;
        return Objects.equals(this.consoleAccess(), other.consoleAccess()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.pendingChangeAsString(), other.pendingChangeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UserPendingChanges").add("ConsoleAccess", (Object)this.consoleAccess()).add("Groups", this.hasGroups() ? this.groups() : null).add("PendingChange", (Object)this.pendingChangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsoleAccess": {
                return Optional.ofNullable(clazz.cast(this.consoleAccess()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "PendingChange": {
                return Optional.ofNullable(clazz.cast(this.pendingChangeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consoleAccess", CONSOLE_ACCESS_FIELD);
        map.put("groups", GROUPS_FIELD);
        map.put("pendingChange", PENDING_CHANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserPendingChanges, T> g) {
        return obj -> g.apply((UserPendingChanges)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean consoleAccess;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String pendingChange;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPendingChanges model) {
            this.consoleAccess(model.consoleAccess);
            this.groups(model.groups);
            this.pendingChange(model.pendingChange);
        }

        public final Boolean getConsoleAccess() {
            return this.consoleAccess;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final Collection<String> getGroups() {
            if (this.groups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final String getPendingChange() {
            return this.pendingChange;
        }

        public final void setPendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
        }

        @Override
        public final Builder pendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
            return this;
        }

        @Override
        public final Builder pendingChange(ChangeType pendingChange) {
            this.pendingChange(pendingChange == null ? null : pendingChange.toString());
            return this;
        }

        public UserPendingChanges build() {
            return new UserPendingChanges(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPendingChanges> {
        public Builder consoleAccess(Boolean var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder pendingChange(String var1);

        public Builder pendingChange(ChangeType var1);
    }
}

