/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachmentRoutingPolicyAssociationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttachmentRoutingPolicyAssociationSummary> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(AttachmentRoutingPolicyAssociationSummary.getter(AttachmentRoutingPolicyAssociationSummary::attachmentId)).setter(AttachmentRoutingPolicyAssociationSummary.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()}).build();
    private static final SdkField<List<String>> PENDING_ROUTING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PendingRoutingPolicies").getter(AttachmentRoutingPolicyAssociationSummary.getter(AttachmentRoutingPolicyAssociationSummary::pendingRoutingPolicies)).setter(AttachmentRoutingPolicyAssociationSummary.setter(Builder::pendingRoutingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingRoutingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_ROUTING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedRoutingPolicies").getter(AttachmentRoutingPolicyAssociationSummary.getter(AttachmentRoutingPolicyAssociationSummary::associatedRoutingPolicies)).setter(AttachmentRoutingPolicyAssociationSummary.setter(Builder::associatedRoutingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoutingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTING_POLICY_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingPolicyLabel").getter(AttachmentRoutingPolicyAssociationSummary.getter(AttachmentRoutingPolicyAssociationSummary::routingPolicyLabel)).setter(AttachmentRoutingPolicyAssociationSummary.setter(Builder::routingPolicyLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingPolicyLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, PENDING_ROUTING_POLICIES_FIELD, ASSOCIATED_ROUTING_POLICIES_FIELD, ROUTING_POLICY_LABEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttachmentRoutingPolicyAssociationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attachmentId;
    private final List<String> pendingRoutingPolicies;
    private final List<String> associatedRoutingPolicies;
    private final String routingPolicyLabel;

    private AttachmentRoutingPolicyAssociationSummary(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.pendingRoutingPolicies = builder.pendingRoutingPolicies;
        this.associatedRoutingPolicies = builder.associatedRoutingPolicies;
        this.routingPolicyLabel = builder.routingPolicyLabel;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final boolean hasPendingRoutingPolicies() {
        return this.pendingRoutingPolicies != null && !(this.pendingRoutingPolicies instanceof SdkAutoConstructList);
    }

    public final List<String> pendingRoutingPolicies() {
        return this.pendingRoutingPolicies;
    }

    public final boolean hasAssociatedRoutingPolicies() {
        return this.associatedRoutingPolicies != null && !(this.associatedRoutingPolicies instanceof SdkAutoConstructList);
    }

    public final List<String> associatedRoutingPolicies() {
        return this.associatedRoutingPolicies;
    }

    public final String routingPolicyLabel() {
        return this.routingPolicyLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingRoutingPolicies() ? this.pendingRoutingPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedRoutingPolicies() ? this.associatedRoutingPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routingPolicyLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentRoutingPolicyAssociationSummary)) {
            return false;
        }
        AttachmentRoutingPolicyAssociationSummary other = (AttachmentRoutingPolicyAssociationSummary)obj;
        return Objects.equals(this.attachmentId(), other.attachmentId()) && this.hasPendingRoutingPolicies() == other.hasPendingRoutingPolicies() && Objects.equals(this.pendingRoutingPolicies(), other.pendingRoutingPolicies()) && this.hasAssociatedRoutingPolicies() == other.hasAssociatedRoutingPolicies() && Objects.equals(this.associatedRoutingPolicies(), other.associatedRoutingPolicies()) && Objects.equals(this.routingPolicyLabel(), other.routingPolicyLabel());
    }

    public final String toString() {
        return ToString.builder((String)"AttachmentRoutingPolicyAssociationSummary").add("AttachmentId", (Object)this.attachmentId()).add("PendingRoutingPolicies", this.hasPendingRoutingPolicies() ? this.pendingRoutingPolicies() : null).add("AssociatedRoutingPolicies", this.hasAssociatedRoutingPolicies() ? this.associatedRoutingPolicies() : null).add("RoutingPolicyLabel", (Object)this.routingPolicyLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "PendingRoutingPolicies": {
                return Optional.ofNullable(clazz.cast(this.pendingRoutingPolicies()));
            }
            case "AssociatedRoutingPolicies": {
                return Optional.ofNullable(clazz.cast(this.associatedRoutingPolicies()));
            }
            case "RoutingPolicyLabel": {
                return Optional.ofNullable(clazz.cast(this.routingPolicyLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("PendingRoutingPolicies", PENDING_ROUTING_POLICIES_FIELD);
        map.put("AssociatedRoutingPolicies", ASSOCIATED_ROUTING_POLICIES_FIELD);
        map.put("RoutingPolicyLabel", ROUTING_POLICY_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachmentRoutingPolicyAssociationSummary, T> g) {
        return obj -> g.apply((AttachmentRoutingPolicyAssociationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentId;
        private List<String> pendingRoutingPolicies = DefaultSdkAutoConstructList.getInstance();
        private List<String> associatedRoutingPolicies = DefaultSdkAutoConstructList.getInstance();
        private String routingPolicyLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachmentRoutingPolicyAssociationSummary model) {
            this.attachmentId(model.attachmentId);
            this.pendingRoutingPolicies(model.pendingRoutingPolicies);
            this.associatedRoutingPolicies(model.associatedRoutingPolicies);
            this.routingPolicyLabel(model.routingPolicyLabel);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Collection<String> getPendingRoutingPolicies() {
            if (this.pendingRoutingPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pendingRoutingPolicies;
        }

        public final void setPendingRoutingPolicies(Collection<String> pendingRoutingPolicies) {
            this.pendingRoutingPolicies = ConstrainedStringListCopier.copy(pendingRoutingPolicies);
        }

        @Override
        public final Builder pendingRoutingPolicies(Collection<String> pendingRoutingPolicies) {
            this.pendingRoutingPolicies = ConstrainedStringListCopier.copy(pendingRoutingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRoutingPolicies(String ... pendingRoutingPolicies) {
            this.pendingRoutingPolicies(Arrays.asList(pendingRoutingPolicies));
            return this;
        }

        public final Collection<String> getAssociatedRoutingPolicies() {
            if (this.associatedRoutingPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedRoutingPolicies;
        }

        public final void setAssociatedRoutingPolicies(Collection<String> associatedRoutingPolicies) {
            this.associatedRoutingPolicies = ConstrainedStringListCopier.copy(associatedRoutingPolicies);
        }

        @Override
        public final Builder associatedRoutingPolicies(Collection<String> associatedRoutingPolicies) {
            this.associatedRoutingPolicies = ConstrainedStringListCopier.copy(associatedRoutingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoutingPolicies(String ... associatedRoutingPolicies) {
            this.associatedRoutingPolicies(Arrays.asList(associatedRoutingPolicies));
            return this;
        }

        public final String getRoutingPolicyLabel() {
            return this.routingPolicyLabel;
        }

        public final void setRoutingPolicyLabel(String routingPolicyLabel) {
            this.routingPolicyLabel = routingPolicyLabel;
        }

        @Override
        public final Builder routingPolicyLabel(String routingPolicyLabel) {
            this.routingPolicyLabel = routingPolicyLabel;
            return this;
        }

        public AttachmentRoutingPolicyAssociationSummary build() {
            return new AttachmentRoutingPolicyAssociationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttachmentRoutingPolicyAssociationSummary> {
        public Builder attachmentId(String var1);

        public Builder pendingRoutingPolicies(Collection<String> var1);

        public Builder pendingRoutingPolicies(String ... var1);

        public Builder associatedRoutingPolicies(Collection<String> var1);

        public Builder associatedRoutingPolicies(String ... var1);

        public Builder routingPolicyLabel(String var1);
    }
}

