/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptions;
import software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath;
import software.amazon.awssdk.services.networkmanager.model.RouteAnalysisStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteAnalysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteAnalysis> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(RouteAnalysis.getter(RouteAnalysis::globalNetworkId)).setter(RouteAnalysis.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalNetworkId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(RouteAnalysis.getter(RouteAnalysis::ownerAccountId)).setter(RouteAnalysis.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> ROUTE_ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteAnalysisId").getter(RouteAnalysis.getter(RouteAnalysis::routeAnalysisId)).setter(RouteAnalysis.setter(Builder::routeAnalysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteAnalysisId").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(RouteAnalysis.getter(RouteAnalysis::startTimestamp)).setter(RouteAnalysis.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RouteAnalysis.getter(RouteAnalysis::statusAsString)).setter(RouteAnalysis.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<RouteAnalysisEndpointOptions> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(RouteAnalysis.getter(RouteAnalysis::source)).setter(RouteAnalysis.setter(Builder::source)).constructor(RouteAnalysisEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<RouteAnalysisEndpointOptions> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(RouteAnalysis.getter(RouteAnalysis::destination)).setter(RouteAnalysis.setter(Builder::destination)).constructor(RouteAnalysisEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<Boolean> INCLUDE_RETURN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeReturnPath").getter(RouteAnalysis.getter(RouteAnalysis::includeReturnPath)).setter(RouteAnalysis.setter(Builder::includeReturnPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeReturnPath").build()}).build();
    private static final SdkField<Boolean> USE_MIDDLEBOXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseMiddleboxes").getter(RouteAnalysis.getter(RouteAnalysis::useMiddleboxes)).setter(RouteAnalysis.setter(Builder::useMiddleboxes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseMiddleboxes").build()}).build();
    private static final SdkField<RouteAnalysisPath> FORWARD_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForwardPath").getter(RouteAnalysis.getter(RouteAnalysis::forwardPath)).setter(RouteAnalysis.setter(Builder::forwardPath)).constructor(RouteAnalysisPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardPath").build()}).build();
    private static final SdkField<RouteAnalysisPath> RETURN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReturnPath").getter(RouteAnalysis.getter(RouteAnalysis::returnPath)).setter(RouteAnalysis.setter(Builder::returnPath)).constructor(RouteAnalysisPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, OWNER_ACCOUNT_ID_FIELD, ROUTE_ANALYSIS_ID_FIELD, START_TIMESTAMP_FIELD, STATUS_FIELD, SOURCE_FIELD, DESTINATION_FIELD, INCLUDE_RETURN_PATH_FIELD, USE_MIDDLEBOXES_FIELD, FORWARD_PATH_FIELD, RETURN_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteAnalysis.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String globalNetworkId;
    private final String ownerAccountId;
    private final String routeAnalysisId;
    private final Instant startTimestamp;
    private final String status;
    private final RouteAnalysisEndpointOptions source;
    private final RouteAnalysisEndpointOptions destination;
    private final Boolean includeReturnPath;
    private final Boolean useMiddleboxes;
    private final RouteAnalysisPath forwardPath;
    private final RouteAnalysisPath returnPath;

    private RouteAnalysis(BuilderImpl builder) {
        this.globalNetworkId = builder.globalNetworkId;
        this.ownerAccountId = builder.ownerAccountId;
        this.routeAnalysisId = builder.routeAnalysisId;
        this.startTimestamp = builder.startTimestamp;
        this.status = builder.status;
        this.source = builder.source;
        this.destination = builder.destination;
        this.includeReturnPath = builder.includeReturnPath;
        this.useMiddleboxes = builder.useMiddleboxes;
        this.forwardPath = builder.forwardPath;
        this.returnPath = builder.returnPath;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public final String routeAnalysisId() {
        return this.routeAnalysisId;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final RouteAnalysisStatus status() {
        return RouteAnalysisStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final RouteAnalysisEndpointOptions source() {
        return this.source;
    }

    public final RouteAnalysisEndpointOptions destination() {
        return this.destination;
    }

    public final Boolean includeReturnPath() {
        return this.includeReturnPath;
    }

    public final Boolean useMiddleboxes() {
        return this.useMiddleboxes;
    }

    public final RouteAnalysisPath forwardPath() {
        return this.forwardPath;
    }

    public final RouteAnalysisPath returnPath() {
        return this.returnPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeReturnPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.useMiddleboxes());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysis)) {
            return false;
        }
        RouteAnalysis other = (RouteAnalysis)obj;
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.routeAnalysisId(), other.routeAnalysisId()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.includeReturnPath(), other.includeReturnPath()) && Objects.equals(this.useMiddleboxes(), other.useMiddleboxes()) && Objects.equals(this.forwardPath(), other.forwardPath()) && Objects.equals(this.returnPath(), other.returnPath());
    }

    public final String toString() {
        return ToString.builder((String)"RouteAnalysis").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("RouteAnalysisId", (Object)this.routeAnalysisId()).add("StartTimestamp", (Object)this.startTimestamp()).add("Status", (Object)this.statusAsString()).add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("IncludeReturnPath", (Object)this.includeReturnPath()).add("UseMiddleboxes", (Object)this.useMiddleboxes()).add("ForwardPath", (Object)this.forwardPath()).add("ReturnPath", (Object)this.returnPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "RouteAnalysisId": {
                return Optional.ofNullable(clazz.cast(this.routeAnalysisId()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "IncludeReturnPath": {
                return Optional.ofNullable(clazz.cast(this.includeReturnPath()));
            }
            case "UseMiddleboxes": {
                return Optional.ofNullable(clazz.cast(this.useMiddleboxes()));
            }
            case "ForwardPath": {
                return Optional.ofNullable(clazz.cast(this.forwardPath()));
            }
            case "ReturnPath": {
                return Optional.ofNullable(clazz.cast(this.returnPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GlobalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("RouteAnalysisId", ROUTE_ANALYSIS_ID_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("IncludeReturnPath", INCLUDE_RETURN_PATH_FIELD);
        map.put("UseMiddleboxes", USE_MIDDLEBOXES_FIELD);
        map.put("ForwardPath", FORWARD_PATH_FIELD);
        map.put("ReturnPath", RETURN_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteAnalysis, T> g) {
        return obj -> g.apply((RouteAnalysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private String ownerAccountId;
        private String routeAnalysisId;
        private Instant startTimestamp;
        private String status;
        private RouteAnalysisEndpointOptions source;
        private RouteAnalysisEndpointOptions destination;
        private Boolean includeReturnPath;
        private Boolean useMiddleboxes;
        private RouteAnalysisPath forwardPath;
        private RouteAnalysisPath returnPath;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAnalysis model) {
            this.globalNetworkId(model.globalNetworkId);
            this.ownerAccountId(model.ownerAccountId);
            this.routeAnalysisId(model.routeAnalysisId);
            this.startTimestamp(model.startTimestamp);
            this.status(model.status);
            this.source(model.source);
            this.destination(model.destination);
            this.includeReturnPath(model.includeReturnPath);
            this.useMiddleboxes(model.useMiddleboxes);
            this.forwardPath(model.forwardPath);
            this.returnPath(model.returnPath);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getRouteAnalysisId() {
            return this.routeAnalysisId;
        }

        public final void setRouteAnalysisId(String routeAnalysisId) {
            this.routeAnalysisId = routeAnalysisId;
        }

        @Override
        public final Builder routeAnalysisId(String routeAnalysisId) {
            this.routeAnalysisId = routeAnalysisId;
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RouteAnalysisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RouteAnalysisEndpointOptions.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(RouteAnalysisEndpointOptions.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(RouteAnalysisEndpointOptions source) {
            this.source = source;
            return this;
        }

        public final RouteAnalysisEndpointOptions.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(RouteAnalysisEndpointOptions.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(RouteAnalysisEndpointOptions destination) {
            this.destination = destination;
            return this;
        }

        public final Boolean getIncludeReturnPath() {
            return this.includeReturnPath;
        }

        public final void setIncludeReturnPath(Boolean includeReturnPath) {
            this.includeReturnPath = includeReturnPath;
        }

        @Override
        public final Builder includeReturnPath(Boolean includeReturnPath) {
            this.includeReturnPath = includeReturnPath;
            return this;
        }

        public final Boolean getUseMiddleboxes() {
            return this.useMiddleboxes;
        }

        public final void setUseMiddleboxes(Boolean useMiddleboxes) {
            this.useMiddleboxes = useMiddleboxes;
        }

        @Override
        public final Builder useMiddleboxes(Boolean useMiddleboxes) {
            this.useMiddleboxes = useMiddleboxes;
            return this;
        }

        public final RouteAnalysisPath.Builder getForwardPath() {
            return this.forwardPath != null ? this.forwardPath.toBuilder() : null;
        }

        public final void setForwardPath(RouteAnalysisPath.BuilderImpl forwardPath) {
            this.forwardPath = forwardPath != null ? forwardPath.build() : null;
        }

        @Override
        public final Builder forwardPath(RouteAnalysisPath forwardPath) {
            this.forwardPath = forwardPath;
            return this;
        }

        public final RouteAnalysisPath.Builder getReturnPath() {
            return this.returnPath != null ? this.returnPath.toBuilder() : null;
        }

        public final void setReturnPath(RouteAnalysisPath.BuilderImpl returnPath) {
            this.returnPath = returnPath != null ? returnPath.build() : null;
        }

        @Override
        public final Builder returnPath(RouteAnalysisPath returnPath) {
            this.returnPath = returnPath;
            return this;
        }

        public RouteAnalysis build() {
            return new RouteAnalysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteAnalysis> {
        public Builder globalNetworkId(String var1);

        public Builder ownerAccountId(String var1);

        public Builder routeAnalysisId(String var1);

        public Builder startTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(RouteAnalysisStatus var1);

        public Builder source(RouteAnalysisEndpointOptions var1);

        default public Builder source(Consumer<RouteAnalysisEndpointOptions.Builder> source) {
            return this.source((RouteAnalysisEndpointOptions)((RouteAnalysisEndpointOptions.Builder)RouteAnalysisEndpointOptions.builder().applyMutation(source)).build());
        }

        public Builder destination(RouteAnalysisEndpointOptions var1);

        default public Builder destination(Consumer<RouteAnalysisEndpointOptions.Builder> destination) {
            return this.destination((RouteAnalysisEndpointOptions)((RouteAnalysisEndpointOptions.Builder)RouteAnalysisEndpointOptions.builder().applyMutation(destination)).build());
        }

        public Builder includeReturnPath(Boolean var1);

        public Builder useMiddleboxes(Boolean var1);

        public Builder forwardPath(RouteAnalysisPath var1);

        default public Builder forwardPath(Consumer<RouteAnalysisPath.Builder> forwardPath) {
            return this.forwardPath((RouteAnalysisPath)((RouteAnalysisPath.Builder)RouteAnalysisPath.builder().applyMutation(forwardPath)).build());
        }

        public Builder returnPath(RouteAnalysisPath var1);

        default public Builder returnPath(Consumer<RouteAnalysisPath.Builder> returnPath) {
            return this.returnPath((RouteAnalysisPath)((RouteAnalysisPath.Builder)RouteAnalysisPath.builder().applyMutation(returnPath)).build());
        }
    }
}

